/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.parts;

import com.liferay.ide.layouttpl.core.model.PortletColumnElement;
import com.liferay.ide.layouttpl.ui.draw2d.ColumnFigure;
import com.liferay.ide.layouttpl.ui.parts.PortletLayoutEditPart;
import com.liferay.ide.layouttpl.ui.parts.PortletRowLayoutEditPart;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.graphics.Color;

public class PortletColumnEditPart
extends PortletRowLayoutEditPart {
    public static final int COLUMN_MARGIN = 5;

    @Override
    protected IFigure createFigure() {
        Figure f;
        if (this.getModelChildren().isEmpty()) {
            f = this.createFigureForModel();
            f.setOpaque(true);
        } else {
            f = super.createFigure();
        }
        f.setBackgroundColor(new Color(null, 232, 232, 232));
        return f;
    }

    protected Figure createFigureForModel() {
        if (this.getModel() instanceof PortletColumnElement) {
            ColumnFigure rect = new ColumnFigure();
            rect.setCornerDimensions(new Dimension(10, 10));
            return rect;
        }
        throw new IllegalArgumentException();
    }

    public GridData createGridData() {
        GridData gd = new GridData(16384, 4, false, true, 1, 1);
        gd.heightHint = this.getCastedParent().getDefaultColumnHeight();
        return gd;
    }

    @Override
    protected Panel createPanel() {
        return new Panel(){

            protected void paintFigure(Graphics graphics) {
                Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
                --r.width;
                --r.height;
                graphics.drawRoundRectangle(r, 10, 10);
                --r.width;
                --r.height;
                ++r.x;
                ++r.y;
                graphics.fillRoundRectangle(r, 10, 10);
            }
        };
    }

    public PortletColumnElement getCastedModel() {
        return (PortletColumnElement)this.getModel();
    }

    public PortletLayoutEditPart getCastedParent() {
        return (PortletLayoutEditPart)this.getParent();
    }

    @Override
    public int getMargin() {
        return 5;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        Object constraint = ((GraphicalEditPart)this.getParent()).getFigure().getLayoutManager().getConstraint(this.getFigure());
        GridData gd = null;
        if (constraint instanceof GridData) {
            gd = (GridData)constraint;
            if (gd.heightHint == -1) {
                gd.heightHint = this.getCastedParent().getDefaultColumnHeight();
            }
        } else {
            gd = this.createGridData();
        }
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)gd);
        if (this.getFigure() instanceof ColumnFigure) {
            ((ColumnFigure)this.getFigure()).setText(((Integer)this.getCastedModel().getWeight().content()).toString());
        }
    }

    protected void createEditPolicies() {
    }
}

