/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.parts;

import com.liferay.ide.layouttpl.core.model.CanAddPortletLayouts;
import com.liferay.ide.layouttpl.core.model.PortletLayoutElement;
import com.liferay.ide.layouttpl.ui.parts.BaseGraphicalEditPart;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.sapphire.ElementList;

public abstract class PortletRowLayoutEditPart
extends BaseGraphicalEditPart {
    public static final int DEFAULT_COLUMN_HEIGHT = -1;
    protected Panel panel;

    protected void configurePanel(Panel panel) {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        panel.setLayoutManager((LayoutManager)gridLayout);
        panel.setBorder((Border)new MarginBorder(this.getMargin()));
    }

    protected IFigure createFigure() {
        this.panel = this.createPanel();
        this.configurePanel(this.panel);
        return this.panel;
    }

    protected Panel createPanel() {
        return new Panel();
    }

    protected CanAddPortletLayouts getCastedModel() {
        return (CanAddPortletLayouts)this.getModel();
    }

    public int getContainerWidth() {
        if (this.panel != null) {
            return this.panel.getSize().width - this.getMargin() * 2;
        }
        return 0;
    }

    public abstract int getMargin();

    protected ElementList<PortletLayoutElement> getModelChildren() {
        return this.getCastedModel().getPortletLayouts();
    }

    public int getPreferredColumnHeight() {
        int retval = -1;
        int numRows = this.getRowPartsCount();
        if (numRows > 1) {
            Rectangle partBounds = this.getFigure().getBounds();
            if (partBounds.height > 0) {
                int computedColumnHeight;
                int partHeight = partBounds.height;
                int rowsHeight = partHeight - this.getMargin() * 2;
                int totalColumnsHeight = rowsHeight - this.getRowPartsCount() * 5 * 2;
                retval = computedColumnHeight = totalColumnsHeight / numRows;
            }
        }
        return retval;
    }

    protected int getRowPartsCount() {
        return this.getChildren().size();
    }

    public void refresh() {
        super.refresh();
        if (this.getChildren() != null) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        List children = this.getChildren();
        for (Object child : children) {
            if (!(child instanceof AbstractEditPart)) continue;
            ((AbstractEditPart)child).refresh();
        }
    }
}

