/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.LiferayLanguagePropertiesValidator;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.PropertiesUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class LiferayLanguagePropertiesListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public LiferayLanguagePropertiesListener() {
        new WorkspaceJob("clear abondoned liferay language properties markers"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                LiferayLanguagePropertiesValidator.clearAbandonedMarkers();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void processFile(IFile file) throws CoreException {
        if (file != null && file.exists()) {
            IFile liferayHookXml;
            IFile portletXml;
            ILiferayProject lrproject;
            if (PropertiesUtil.isLanguagePropertiesFile(file)) {
                this.validateLanguagePropertiesEncoding(new IFile[]{file}, null);
                return;
            }
            String filename = file.getName();
            if (filename.equals("portlet.xml") && (lrproject = LiferayCore.create(CoreUtil.getLiferayProject((IResource)file))) != null && file.equals((Object)(portletXml = lrproject.getDescriptorFile("portlet.xml")))) {
                IFile[] files = PropertiesUtil.getLanguagePropertiesFromPortletXml(portletXml);
                this.validateLanguagePropertiesEncoding(files, CoreUtil.getLiferayProject((IResource)file));
                return;
            }
            if (filename.equals("liferay-hook.xml") && (lrproject = LiferayCore.create(CoreUtil.getLiferayProject((IResource)file))) != null && file.equals((Object)(liferayHookXml = lrproject.getDescriptorFile("liferay-hook.xml")))) {
                IFile[] files = PropertiesUtil.getLanguagePropertiesFromLiferayHookXml(liferayHookXml);
                this.validateLanguagePropertiesEncoding(files, CoreUtil.getLiferayProject((IResource)file));
                return;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        switch (delta.getResource().getType()) {
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
            case 1: {
                this.processFile((IFile)delta.getResource());
                return false;
            }
        }
        return false;
    }

    private void validateLanguagePropertiesEncoding(final IFile[] files, final IProject project) {
        WorkspaceJob job = new WorkspaceJob("Validate Liferay language properties encoding..."){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (files != null && files.length > 0) {
                    IFile[] iFileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile file = iFileArray[n2];
                        LiferayLanguagePropertiesValidator.getValidator(file).validateEncoding();
                        ++n2;
                    }
                }
                if (project != null) {
                    LiferayLanguagePropertiesValidator.clearUnusedValidatorsAndMarkers(project);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)CoreUtil.getWorkspaceRoot());
        job.schedule();
    }
}

