/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.common.ivyfile;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivyde.common.model.IvyFile;
import org.apache.ivyde.common.model.IvyModelSettings;

public class IvyModuleDescriptorFile
extends IvyFile {
    private static final Pattern CONF_PATTERN = Pattern.compile("<[\\s]*conf[^>]+name=\"([^\"]+)");
    private static final Pattern CONFIGURATIONS_END_PATTERN = Pattern.compile("</[\\s]*configurations[\\s]*>");
    private static final Pattern CONFIGURATIONS_START_PATTERN = Pattern.compile("<[\\s]*configurations[\\s]*>");

    public IvyModuleDescriptorFile(IvyModelSettings settings, String projectName, String doc) {
        this(settings, projectName, doc, 0);
    }

    public IvyModuleDescriptorFile(IvyModelSettings settings, String projectName, String doc, int currentOffset) {
        super(settings, projectName, doc, currentOffset);
    }

    public String[] getConfigurationNames() {
        Pattern p = CONFIGURATIONS_START_PATTERN;
        Matcher m = p.matcher(this.getDoc());
        if (m.find()) {
            int start = m.end();
            p = CONFIGURATIONS_END_PATTERN;
            m = p.matcher(this.getDoc());
            int end = this.getDoc().length();
            if (m.find(start)) {
                end = m.start();
            }
            p = CONF_PATTERN;
            m = p.matcher(this.getDoc());
            ArrayList<String> ret = new ArrayList<String>();
            boolean found = m.find(start);
            while (found && m.end() < end) {
                ret.add(m.group(1));
                found = m.find();
            }
            return ret.toArray(new String[ret.size()]);
        }
        return new String[]{"default"};
    }

    public String getOrganisation() {
        Pattern p = Pattern.compile("<[\\s]*info[^>]*organisation[\\s]*=[\\s]*\"([^\"]+)");
        Matcher m = p.matcher(this.getDoc());
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public String getDependencyOrganisation() {
        Map otherAttValues = this.getAllAttsValues();
        return this.getDependencyOrganisation(otherAttValues);
    }

    public String getDependencyOrganisation(Map otherAttValues) {
        return otherAttValues != null && otherAttValues.get("org") != null ? (String)otherAttValues.get("org") : this.getOrganisation();
    }
}

