/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.ivyde.common.ivyfile.IvyFileResourceListener;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.IvyMarkerManager;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyAttachementManager;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerSerializer;
import org.apache.ivyde.internal.eclipse.resolve.IvyResolveJob;
import org.apache.ivyde.internal.eclipse.retrieve.RetrieveSetupManager;
import org.apache.ivyde.internal.eclipse.ui.console.IvyConsole;
import org.apache.ivyde.internal.eclipse.ui.console.IvyConsoleFactory;
import org.apache.ivyde.internal.eclipse.ui.editors.xml.ColorManager;
import org.apache.ivyde.internal.eclipse.ui.preferences.IvyDEPreferenceStoreHelper;
import org.apache.ivyde.internal.eclipse.ui.preferences.PreferenceConstants;
import org.apache.ivyde.internal.eclipse.workspaceresolver.WorkspaceResourceChangeListener;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class IvyPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.apache.ivyde.eclipse";
    public static final String MARKER_ID = "org.apache.ivyde.eclipse.marker";
    private static volatile IvyPlugin plugin;
    private ResourceBundle resourceBundle;
    private IvyConsole console;
    private IvyDEPreferenceStoreHelper prefStoreHelper;
    private BundleContext bundleContext;
    private ColorManager colorManager;
    private IvyResolveJob ivyResolveJob;
    private RetrieveSetupManager retrieveSetupManager;
    private WorkspaceResourceChangeListener workspaceListener;
    private IvyFileResourceListener ivyFileListener;
    private IPropertyChangeListener propertyListener;
    private IvyMarkerManager ivyMarkerManager;
    private boolean osgiAvailable;
    private IvyClasspathContainerSerializer ivyCpcSerializer;
    private IvyAttachementManager ivyAttachementManager;

    public IvyPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
        IvyPlugin.logInfo("starting IvyDE plugin");
        this.ivyResolveJob = new IvyResolveJob();
        this.retrieveSetupManager = new RetrieveSetupManager();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addSaveParticipant((Plugin)this, (ISaveParticipant)this.retrieveSetupManager);
        this.colorManager = new ColorManager();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IvyPlugin.this.colorManager.refreshFromStore(IvyPlugin.this.getPreferenceStore());
            }
        });
        this.prefStoreHelper = new IvyDEPreferenceStoreHelper(this.getPreferenceStore());
        this.propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                try {
                    if (PreferenceConstants.ALL.contains(event.getProperty())) {
                        IvyPlugin.this.prefStoreChanged();
                    }
                }
                catch (JavaModelException e) {
                    MessageDialog.openError((Shell)IvyPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to trigger the update the IvyDE classpath containers", (String)e.getMessage());
                }
            }
        };
        this.getPreferenceStore().addPropertyChangeListener(this.propertyListener);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IvyPlugin.this.console = new IvyConsole();
                    if (IvyPlugin.this.prefStoreHelper.isOpenIvyConsoleOnStartup()) {
                        IvyConsoleFactory.showConsole();
                    }
                }
                catch (RuntimeException e) {
                    IvyPlugin.logError("Errors occurred starting the Ivy console", e);
                }
            }
        });
        this.workspaceListener = new WorkspaceResourceChangeListener();
        workspace.addResourceChangeListener((IResourceChangeListener)this.workspaceListener);
        this.ivyFileListener = new IvyFileResourceListener();
        workspace.addResourceChangeListener((IResourceChangeListener)this.ivyFileListener, 8);
        this.ivyMarkerManager = new IvyMarkerManager();
        File stateLocation = this.getStateLocation().toFile();
        this.ivyAttachementManager = new IvyAttachementManager(new File(stateLocation, "attachements.properties"));
        File containersStateDir = new File(stateLocation, "cpstates");
        if (!containersStateDir.exists()) {
            containersStateDir.mkdirs();
        }
        this.ivyCpcSerializer = new IvyClasspathContainerSerializer(containersStateDir, this.ivyAttachementManager);
        try {
            Class.forName("org.apache.ivy.osgi.core.ManifestParser");
            this.osgiAvailable = true;
        }
        catch (Exception exception) {
            this.osgiAvailable = false;
        }
        IvyPlugin.logInfo("IvyDE plugin started");
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.ivyCpcSerializer = null;
        this.ivyAttachementManager = null;
        this.resourceBundle = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeSaveParticipant((Plugin)this);
        this.colorManager = null;
        this.ivyMarkerManager = null;
        this.ivyResolveJob = null;
        this.retrieveSetupManager = null;
        workspace.removeResourceChangeListener((IResourceChangeListener)this.workspaceListener);
        this.workspaceListener = null;
        workspace.removeResourceChangeListener((IResourceChangeListener)this.ivyFileListener);
        this.ivyFileListener = null;
        this.getPreferenceStore().removePropertyChangeListener(this.propertyListener);
        this.propertyListener = null;
        if (this.console != null) {
            this.console.destroy();
        }
        plugin = null;
    }

    void prefStoreChanged() throws JavaModelException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspace.getRoot());
        IJavaProject[] projects = javaModel.getJavaProjects();
        int i = 0;
        while (i < projects.length) {
            List containers = IvyClasspathContainerHelper.getContainers(projects[i]);
            Iterator itContainers = containers.iterator();
            while (itContainers.hasNext()) {
                IvyClasspathContainerImpl ivycp = (IvyClasspathContainerImpl)itContainers.next();
                if (ivycp.getConf().isSettingsProjectSpecific()) continue;
                ivycp.launchResolve(false, null);
            }
            ++i;
        }
    }

    public static void log(IStatus status) {
        IvyPlugin.getDefault().getLog().log(status);
        switch (status.getCode()) {
            case 4: {
                IvyDEMessage.error(status.getMessage(), status.getException());
                break;
            }
            case 2: 
            case 8: {
                IvyDEMessage.warn(status.getMessage(), status.getException());
                break;
            }
            case 0: 
            case 1: {
                IvyDEMessage.info(status.getMessage(), status.getException());
            }
        }
    }

    public static void log(CoreException e) {
        IvyPlugin.log(e.getStatus().getSeverity(), "IvyDE internal error", e);
    }

    public static void log(int severity, String message, Throwable e) {
        IvyPlugin.log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public static void logInfo(String message) {
        IvyPlugin.log((IStatus)new Status(1, ID, 0, message, null));
    }

    public static void logWarn(String message) {
        IvyPlugin.logWarn(message, null);
    }

    public static void logWarn(String message, Throwable e) {
        IvyPlugin.log((IStatus)new Status(2, ID, 0, message, e));
    }

    public static void logError(String message) {
        IvyPlugin.logError(message, null);
    }

    public static void logError(String message, Throwable e) {
        IvyPlugin.log((IStatus)new Status(4, ID, 0, message, e));
    }

    public static IvyPlugin getDefault() {
        return plugin;
    }

    public boolean isOsgiAvailable() {
        return this.osgiAvailable;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = IvyPlugin.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = IvyPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (IvyPlugin.getDefault() == null) {
            return null;
        }
        IWorkbench workBench = IvyPlugin.getDefault().getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = IvyPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static Object adapt(Object object, Class type) {
        if (type.isInstance(object)) {
            return object;
        }
        if (object instanceof IAdaptable) {
            return ((IAdaptable)object).getAdapter(type);
        }
        return Platform.getAdapterManager().getAdapter(object, type);
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.apache.ivyde.eclipse.IvyPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = new ResourceBundle(){

                protected Object handleGetObject(String key) {
                    return null;
                }

                public Enumeration getKeys() {
                    return Collections.enumeration(Collections.EMPTY_LIST);
                }
            };
        }
        return this.resourceBundle;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static IvyDEPreferenceStoreHelper getPreferenceStoreHelper() {
        return IvyPlugin.plugin.prefStoreHelper;
    }

    public IvyConsole getConsole() {
        return this.console;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public ColorManager getColorManager() {
        return this.colorManager;
    }

    public IvyMarkerManager getIvyMarkerManager() {
        return this.ivyMarkerManager;
    }

    public IvyClasspathContainerSerializer getIvyClasspathContainerSerializer() {
        return this.ivyCpcSerializer;
    }

    public IvyAttachementManager getIvyAttachementManager() {
        return this.ivyAttachementManager;
    }

    public IvyResolveJob getIvyResolveJob() {
        return this.ivyResolveJob;
    }

    public RetrieveSetupManager getRetrieveSetupManager() {
        return this.retrieveSetupManager;
    }
}

