/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.cpcontainer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.ivyde.eclipse.cp.ClasspathSetup;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerConfiguration;
import org.apache.ivyde.eclipse.cp.MappingSetup;
import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyAttachementManager;
import org.apache.ivyde.internal.eclipse.resolve.ResolveResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class IvyClasspathContainerMapper {
    private static final String IVYDE_NS = "http://ant.apache.org/ivy/ivyde/ns/";
    private static final String IVYDE_NS_PREFIX = "ivyde:";
    private final IProgressMonitor monitor;
    private final Ivy ivy;
    private final IJavaProject javaProject;
    private final Collection all;
    private final Map artifactsByDependency;
    private final Map retrievedArtifacts;
    private ClasspathSetup classpathSetup;
    private MappingSetup mapping;
    private boolean osgiAvailable;
    private IvyAttachementManager attachementManager = IvyPlugin.getDefault().getIvyAttachementManager();
    private ArtifactMatcher sourceArtifactMatcher = new ArtifactMatcher(){

        public boolean matchName(Artifact artifact, String source) {
            return IvyClasspathContainerMapper.this.isArtifactName(artifact, source, IvyClasspathContainerMapper.this.mapping.getSourceSuffixes(), "source");
        }

        public boolean match(Artifact a) {
            return IvyClasspathContainerMapper.this.mapping.getSourceTypes().contains(a.getType());
        }

        public String getName() {
            return "sources";
        }
    };
    private ArtifactMatcher javadocArtifactMatcher = new ArtifactMatcher(){

        public boolean matchName(Artifact artifact, String javadoc) {
            return IvyClasspathContainerMapper.this.isArtifactName(artifact, javadoc, IvyClasspathContainerMapper.this.mapping.getJavadocSuffixes(), "javadoc");
        }

        public boolean match(Artifact a) {
            return IvyClasspathContainerMapper.this.mapping.getJavadocTypes().contains(a.getType());
        }

        public String getName() {
            return "javadoc";
        }
    };

    public IvyClasspathContainerMapper(IProgressMonitor monitor, Ivy ivy, IvyClasspathContainerConfiguration conf, ResolveResult resolveResult) {
        this.monitor = monitor;
        this.ivy = ivy;
        this.javaProject = conf.getJavaProject();
        this.classpathSetup = conf.getInheritedClasspathSetup();
        this.mapping = conf.getInheritedMappingSetup();
        this.all = resolveResult.getArtifactReports();
        this.artifactsByDependency = resolveResult.getArtifactsByDependency();
        this.retrievedArtifacts = resolveResult.getRetrievedArtifacts();
        this.osgiAvailable = IvyPlugin.getDefault().isOsgiAvailable();
    }

    public IClasspathEntry[] map() {
        LinkedHashSet<IClasspathEntry> paths = new LinkedHashSet<IClasspathEntry>();
        IvyDEMessage.verbose("Building classpath from " + this.all.size() + " resolved artifact(s)");
        Iterator iter = this.all.iterator();
        while (iter.hasNext()) {
            ArtifactDownloadReport artifact = (ArtifactDownloadReport)iter.next();
            if (artifact.getType().equals("eclipse-project")) {
                IvyDEMessage.verbose("Found an workspace dependency on project " + artifact.getName());
                if (this.javaProject == null || !artifact.getName().equals(this.javaProject.getPath().toString())) {
                    IAccessRule[] rules = this.getAccessRules(this.javaProject);
                    paths.add(JavaCore.newProjectEntry((IPath)new Path(artifact.getName()), (IAccessRule[])rules, (boolean)true, null, (boolean)true));
                    continue;
                }
                IvyDEMessage.verbose("Skipping self dependency on project " + artifact.getName());
                continue;
            }
            if (artifact.getLocalFile() == null || !this.accept(artifact.getArtifact())) continue;
            IvyDEMessage.verbose("Adding " + artifact.getName() + " to the classpath");
            Path classpathArtifact = this.getArtifactPath(artifact);
            Path sourcesArtifact = this.getArtifactPath(artifact, this.sourceArtifactMatcher, this.mapping.isMapIfOnlyOneSource());
            Path javadocArtifact = this.getArtifactPath(artifact, this.javadocArtifactMatcher, this.mapping.isMapIfOnlyOneJavadoc());
            IAccessRule[] rules = this.getAccessRules((IPath)classpathArtifact);
            IPath sources = this.attachementManager.getSourceAttachment((IPath)classpathArtifact, (IPath)sourcesArtifact);
            IPath sourcesRoot = this.attachementManager.getSourceAttachmentRoot((IPath)classpathArtifact, (IPath)sourcesArtifact);
            IClasspathAttribute[] att = this.getExtraAttribute((IPath)classpathArtifact, (IPath)javadocArtifact);
            if (sources != null) {
                IvyDEMessage.debug("Attaching sources " + sources + " to " + classpathArtifact);
            }
            if (javadocArtifact != null) {
                IvyDEMessage.debug("Attaching javadoc " + javadocArtifact + " to " + classpathArtifact);
            }
            if (rules != null) {
                IvyDEMessage.debug("Setting OSGi access rules on  " + classpathArtifact);
            }
            paths.add(JavaCore.newLibraryEntry((IPath)classpathArtifact, (IPath)sources, (IPath)sourcesRoot, (IAccessRule[])rules, (IClasspathAttribute[])att, (boolean)false));
        }
        IClasspathEntry[] classpathEntries = paths.toArray(new IClasspathEntry[paths.size()]);
        return classpathEntries;
    }

    private IAccessRule[] getAccessRules(IJavaProject javaProject) {
        if (!this.osgiAvailable || !this.classpathSetup.isReadOSGiMetadata()) {
            return null;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IAccessRule[] getAccessRules(IPath artifact) {
        BundleInfo bundleInfo;
        block12: {
            if (!this.osgiAvailable) return null;
            if (!this.classpathSetup.isReadOSGiMetadata()) {
                return null;
            }
            FileInputStream jar = null;
            try {
                try {
                    jar = new FileInputStream(artifact.toFile());
                    bundleInfo = ManifestParser.parseJarManifest((InputStream)jar);
                }
                catch (IOException e) {
                    block13: {
                        IvyDEMessage.warn("OSGi metadata could not be extracted from " + artifact + ": " + e.getMessage() + " (" + e.getClass().getName() + ")");
                        break block13;
                        catch (ParseException e2) {
                            IvyDEMessage.warn("OSGi metadata could not be extracted from " + artifact + ": " + e2.getMessage() + " (" + e2.getClass().getName() + ")");
                        }
                    }
                    Object var5_7 = null;
                    if (jar == null) return null;
                    try {
                        jar.close();
                        return null;
                    }
                    catch (IOException iOException) {}
                    return null;
                }
                Object var5_9 = null;
                if (jar == null) break block12;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (jar == null) throw throwable;
                try {}
                catch (IOException iOException) {}
                jar.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            jar.close();
        }
        IAccessRule[] rules = new IAccessRule[bundleInfo.getExports().size() + 1];
        int i = 0;
        Iterator itExports = bundleInfo.getExports().iterator();
        while (itExports.hasNext()) {
            ExportPackage exportPackage = (ExportPackage)itExports.next();
            rules[i++] = JavaCore.newAccessRule((IPath)new Path(String.valueOf(exportPackage.getName().replace('.', '/')) + "/*"), (int)0);
        }
        rules[i++] = JavaCore.newAccessRule((IPath)new Path("**/*"), (int)257);
        return rules;
    }

    private Path getArtifactPath(ArtifactDownloadReport artifact) {
        Set pathSet;
        if (this.retrievedArtifacts != null && (pathSet = (Set)this.retrievedArtifacts.get(artifact)) != null && !pathSet.isEmpty()) {
            return new Path((String)pathSet.iterator().next());
        }
        return new Path(artifact.getLocalFile().getAbsolutePath());
    }

    private Path getArtifactPath(ArtifactDownloadReport adr, ArtifactMatcher matcher, boolean mapIfOnlyOne) {
        Artifact artifact = adr.getArtifact();
        this.monitor.subTask("searching " + matcher.getName() + " for " + artifact);
        Iterator iter = this.all.iterator();
        while (iter.hasNext()) {
            ArtifactDownloadReport otherAdr = (ArtifactDownloadReport)iter.next();
            Artifact a = otherAdr.getArtifact();
            if (otherAdr.getLocalFile() == null || !matcher.matchName(artifact, a.getName()) || !a.getModuleRevisionId().equals((Object)artifact.getModuleRevisionId()) || !matcher.match(a)) continue;
            return this.getArtifactPath(otherAdr);
        }
        ModuleRevisionId mrid = artifact.getId().getModuleRevisionId();
        Artifact[] artifacts = (Artifact[])this.artifactsByDependency.get(mrid);
        if (artifacts != null) {
            ArtifactDownloadReport metaAdr;
            Artifact foundArtifact = null;
            int nbFound = 0;
            int i = 0;
            while (i < artifacts.length) {
                Artifact metaArtifact = artifacts[i];
                if (matcher.match(metaArtifact)) {
                    ArtifactDownloadReport metaAdr2;
                    if (matcher.matchName(artifact, metaArtifact.getName()) && (metaAdr2 = this.ivy.getResolveEngine().download(metaArtifact, new DownloadOptions())).getLocalFile() != null && metaAdr2.getLocalFile().exists()) {
                        return this.getArtifactPath(metaAdr2);
                    }
                    ++nbFound;
                    foundArtifact = metaArtifact;
                }
                ++i;
            }
            if (mapIfOnlyOne && nbFound == 1 && (metaAdr = this.ivy.getResolveEngine().download(foundArtifact, new DownloadOptions())).getLocalFile() != null && metaAdr.getLocalFile().exists()) {
                return new Path(metaAdr.getLocalFile().getAbsolutePath());
            }
        }
        return null;
    }

    private boolean isArtifactName(Artifact artifact, String name, Collection suffixes, String type) {
        String artifactNameToMatch = artifact.getExtraAttribute(IVYDE_NS_PREFIX + type);
        if (artifactNameToMatch != null) {
            return name.equals(artifactNameToMatch);
        }
        String jar = artifact.getName();
        if (name.equals(jar)) {
            return true;
        }
        Iterator it = suffixes.iterator();
        while (it.hasNext()) {
            if (!name.equals(String.valueOf(jar) + it.next())) continue;
            return true;
        }
        return false;
    }

    private IClasspathAttribute[] getExtraAttribute(IPath classpathArtifact, IPath javadocArtifact) {
        IPath path;
        ArrayList<IClasspathAttribute> result = new ArrayList<IClasspathAttribute>();
        URL url = this.attachementManager.getDocAttachment(classpathArtifact);
        if (url == null && (path = javadocArtifact) != null) {
            try {
                String u = "jar:" + path.toFile().toURI().toURL().toExternalForm() + "!/";
                try {
                    url = new URL(u);
                }
                catch (MalformedURLException e) {
                    IvyPlugin.logError("The jar URL for the javadoc is not formed correctly " + u, e);
                }
            }
            catch (MalformedURLException e) {
                IvyPlugin.logError("The path has not a correct URL: " + path, e);
            }
        }
        if (url != null) {
            result.add(JavaCore.newClasspathAttribute((String)"javadoc_location", (String)url.toExternalForm()));
        }
        return result.toArray(new IClasspathAttribute[result.size()]);
    }

    public boolean accept(Artifact artifact) {
        boolean accepted = this.classpathSetup.getAcceptedTypes().contains(artifact.getType());
        if (!accepted && this.classpathSetup.getAcceptedTypes().size() == 1 && this.classpathSetup.getAcceptedTypes().get(0).equals("*")) {
            accepted = true;
        }
        return accepted && !this.mapping.getSourceTypes().contains(artifact.getType()) && !this.mapping.getJavadocTypes().contains(artifact.getType());
    }

    static interface ArtifactMatcher {
        public boolean matchName(Artifact var1, String var2);

        public boolean match(Artifact var1);

        public String getName();
    }
}

