/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.resolve;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;

public class ResolveResult {
    private final boolean previousUsed;
    private Set artifactReports = new LinkedHashSet();
    private Set problemMessages = new HashSet();
    private final ResolveReport report;
    private Map artifactsByDependency = new HashMap();
    private Map retrievedArtifacts;

    ResolveResult() {
        this.report = null;
        this.previousUsed = true;
    }

    ResolveResult(ResolveReport report) {
        this.report = report;
        this.previousUsed = false;
        this.problemMessages = new HashSet(report.getAllProblemMessages());
    }

    public boolean isPreviousUsed() {
        return this.previousUsed;
    }

    public ResolveReport getReport() {
        return this.report;
    }

    public Set getProblemMessages() {
        return this.problemMessages;
    }

    void addArtifactReports(ArtifactDownloadReport[] reports) {
        this.artifactReports.addAll(Arrays.asList(reports));
    }

    void putArtifactsForDep(ModuleRevisionId resolvedId, Artifact[] allArtifacts) {
        this.artifactsByDependency.put(resolvedId, allArtifacts);
    }

    public Set getArtifactReports() {
        return this.artifactReports;
    }

    public Map getArtifactsByDependency() {
        return this.artifactsByDependency;
    }

    void setRetrievedArtifacts(Map retrievedArtifacts) {
        this.retrievedArtifacts = retrievedArtifacts;
    }

    public Map getRetrievedArtifacts() {
        return this.retrievedArtifacts;
    }
}

