/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvydeContainerPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class NewIvyDEContainerWizard
extends Wizard {
    private IvydeContainerPage containerPage = new IvydeContainerPage();

    public NewIvyDEContainerWizard(IJavaProject project, IFile ivyfile) {
        this.containerPage.initialize(project, null);
        this.containerPage.setSelection(ivyfile);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.containerPage);
    }

    public boolean performFinish() {
        this.containerPage.finish();
        IClasspathEntry newEntry = this.containerPage.getSelection();
        IPath path = newEntry.getPath();
        IJavaProject project = this.containerPage.getProject();
        try {
            IvyClasspathContainerImpl ivycp = new IvyClasspathContainerImpl(project, path, new IClasspathEntry[0], new IClasspathAttribute[0]);
            JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{ivycp}, null);
            IClasspathEntry[] entries = project.getRawClasspath();
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(Arrays.asList(entries));
            newEntries.add(newEntry);
            entries = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
            project.setRawClasspath(entries, project.getOutputLocation(), null);
            ivycp.launchResolve(false, null);
        }
        catch (JavaModelException e) {
            IvyPlugin.log((CoreException)((Object)e));
            return false;
        }
        return true;
    }
}

