/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.docsys;

import org.eclipse.sapphire.modeling.docsys.BoldPart;
import org.eclipse.sapphire.modeling.docsys.DocumentationContent;
import org.eclipse.sapphire.modeling.docsys.DocumentationPart;
import org.eclipse.sapphire.modeling.docsys.LineBreakPart;
import org.eclipse.sapphire.modeling.docsys.ListItem;
import org.eclipse.sapphire.modeling.docsys.ListPart;
import org.eclipse.sapphire.modeling.docsys.OrderedListPart;
import org.eclipse.sapphire.modeling.docsys.ParagraphBreakPart;
import org.eclipse.sapphire.modeling.docsys.TextPart;
import org.eclipse.sapphire.modeling.docsys.UnorderedListPart;

public final class HtmlFormatter {
    public static String format(DocumentationContent content) {
        StringBuilder buf = new StringBuilder();
        HtmlFormatter.format(buf, content);
        return buf.toString();
    }

    private static void format(StringBuilder buf, DocumentationPart part) {
        if (part instanceof TextPart) {
            buf.append(((TextPart)part).getText());
        } else if (part instanceof LineBreakPart) {
            buf.append("<br/>");
        } else if (part instanceof ParagraphBreakPart) {
            buf.append("<br/><br/>");
        } else if (part instanceof BoldPart) {
            if (((BoldPart)part).isOpen()) {
                buf.append("<b>");
            } else {
                buf.append("</b>");
            }
        } else if (part instanceof OrderedListPart) {
            buf.append("<ol>");
            for (ListItem item : ((ListPart)part).getItems()) {
                HtmlFormatter.format(buf, item);
            }
            buf.append("</ol>");
        } else if (part instanceof UnorderedListPart) {
            buf.append("<ul>");
            for (ListItem item : ((ListPart)part).getItems()) {
                HtmlFormatter.format(buf, item);
            }
            buf.append("</ul>");
        } else if (part instanceof ListItem) {
            buf.append("<li>");
            for (DocumentationPart child : ((ListItem)part).getChildren()) {
                HtmlFormatter.format(buf, child);
            }
            buf.append("</li>");
        } else if (part instanceof DocumentationContent) {
            for (DocumentationPart child : ((DocumentationContent)part).getChildren()) {
                HtmlFormatter.format(buf, child);
            }
        }
    }
}

