/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.ui.LiferayDefaultCodeFormatterSettings;
import com.liferay.ide.ui.WorkspaceHelper;
import com.liferay.ide.ui.templates.ServiceClassNameResolver;
import com.liferay.ide.ui.util.UIUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileStore;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.prefs.BackingStoreException;

public class LiferayUIPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String FIRST_STARTUP_COMPLETE = "FIRST_STARTUP_COMPLETE";
    public static final String IMG_LIFERAY_ICON_SMALL = "IMG_LIFERAY_ICON_SMALL";
    public static final String PLUGIN_ID = "com.liferay.ide.ui";
    private static LiferayUIPlugin plugin;
    private ServiceListener serviceListener;
    protected TextFileDocumentProvider fTextFileDocumentProvider;
    protected Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>();

    public static void clearAllPersistentSettings() throws BackingStoreException {
        IEclipsePreferences tomcatCorePrefs = new InstanceScope().getNode("com.liferay.ide.server.tomcat.core");
        tomcatCorePrefs.remove("ADDED_EXT_PLUGIN_TOGGLE_KEY");
        tomcatCorePrefs.remove("ADDED_EXT_PLUGIN_WITHOUT_ZIP_TOGGLE_KEY");
        tomcatCorePrefs.remove("REMOVE_EXT_PLUGIN_TOGGLE_KEY");
        tomcatCorePrefs.flush();
    }

    public static IStatus createErrorStatus(String string) {
        return new Status(4, PLUGIN_ID, string);
    }

    public static void logError(String msg, Exception e) {
        LiferayUIPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, (Throwable)e));
    }

    public static IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static LiferayUIPlugin getDefault() {
        return plugin;
    }

    public static Map getLiferaySettings() {
        Map options = new DefaultCodeFormatterOptions(LiferayDefaultCodeFormatterSettings.settings).getMap();
        ProfileVersioner.setLatestCompliance((Map)options);
        return options;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void logError(Exception e) {
        LiferayUIPlugin.logError(e.getMessage(), e);
    }

    private void applyWorkspaceBadge() {
        final String workspaceName = CoreUtil.getWorkspaceRoot().getLocation().lastSegment();
        UIUtil.async(new Runnable(){

            @Override
            public void run() {
                try {
                    Display display = Display.getDefault();
                    Shell shell = display.getActiveShell();
                    TaskBar taskBar = display.getSystemTaskBar();
                    TaskItem taskItem = taskBar.getItem(shell);
                    if (taskItem == null) {
                        taskItem = taskBar.getItem(null);
                    }
                    taskItem.setOverlayText(workspaceName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void earlyStartup() {
        if (this.isFirstStartup()) {
            this.installLiferayFormatterProfile();
            this.firstStartupComplete();
        }
        this.registerMBeans();
        this.lookupLiferay7SDKDir();
        this.applyWorkspaceBadge();
        this.registerResolvers();
    }

    private void lookupLiferay7SDKDir() {
        SDK sdk;
        String liferay7SDKdir = System.getProperty("liferay7.sdk.dir");
        if (liferay7SDKdir != null && liferay7SDKdir.startsWith("\"")) {
            liferay7SDKdir = liferay7SDKdir.substring(1);
        }
        if (liferay7SDKdir != null && liferay7SDKdir.endsWith("\"")) {
            liferay7SDKdir = liferay7SDKdir.substring(0, liferay7SDKdir.length() - 1);
        }
        if (liferay7SDKdir != null && (sdk = SDKUtil.createSDKFromLocation((IPath)new Path(liferay7SDKdir))) != null) {
            new WorkspaceJob("Opening Liferay 7 Plugins SDK Project"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    SDKUtil.openAsProject((SDK)sdk);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        this.getImageRegistry();
        return this.imageDescriptors.get(key);
    }

    public synchronized IDocumentProvider getTextFileDocumentProvider() {
        if (this.fTextFileDocumentProvider == null) {
            this.fTextFileDocumentProvider = new TextFileDocumentProvider();
        }
        return this.fTextFileDocumentProvider;
    }

    private void registerMBeans() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("com.liferay.ide.ui:type=WorkspaceHelper");
            WorkspaceHelper mbean = new WorkspaceHelper();
            mbs.registerMBean(mbean, name);
        }
        catch (Exception e) {
            LiferayUIPlugin.logError("Unable to start workspaceHelper MBean", e);
        }
    }

    private void registerResolvers() {
        ContextTypeRegistry templateContextRegistry = JavaPlugin.getDefault().getTemplateContextRegistry();
        Iterator ctIter = templateContextRegistry.contextTypes();
        while (ctIter.hasNext()) {
            TemplateContextType contextType;
            Object next = ctIter.next();
            if (!(next instanceof TemplateContextType) || !(contextType = (TemplateContextType)next).getId().equals("java")) continue;
            contextType.addResolver((TemplateVariableResolver)new ServiceClassNameResolver());
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.serviceListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                File file;
                String content;
                String[] objectClass = (String[])event.getServiceReference().getProperty("objectClass");
                if (event.getType() == 4 && objectClass[0].equals("org.eclipse.e4.ui.workbench.IWorkbench") && (content = FileUtil.readContents((File)(file = new File(Platform.getLocation().append(".metadata/.plugins/org.eclipse.e4.workbench").toOSString(), "workbench.xmi")), (boolean)true)) != null && content.indexOf("label=\"Liferay\"") != -1) {
                    content = content.replaceFirst("label=\"Liferay\"", "label=\"Liferay Plugins\"");
                    try {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (ByteArrayInputStream ins = new ByteArrayInputStream(content.getBytes());){
                            FileUtil.writeFile((File)file, (InputStream)ins);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        context.addServiceListener(this.serviceListener);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.serviceListener != null) {
            context.removeServiceListener(this.serviceListener);
        }
        super.stop(context);
    }

    private void firstStartupComplete() {
        this.getPreferences().putBoolean(FIRST_STARTUP_COMPLETE, true);
    }

    private IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode(PLUGIN_ID);
    }

    private void installLiferayFormatterProfile() {
        PreferencesAccess access = PreferencesAccess.getOriginalPreferences();
        ProfileVersioner profileVersioner = new ProfileVersioner();
        IScopeContext instanceScope = access.getInstanceScope();
        try {
            try {
                FormatterProfileStore store = new FormatterProfileStore((IProfileVersioner)profileVersioner);
                ArrayList<ProfileManager.CustomProfile> profiles = store.readProfiles(instanceScope);
                if (profiles == null) {
                    profiles = new ArrayList<ProfileManager.CustomProfile>();
                }
                ProfileManager.CustomProfile eclipseProfile = new ProfileManager.CustomProfile("Liferay [plug-in]", LiferayUIPlugin.getLiferaySettings(), profileVersioner.getCurrentVersion(), profileVersioner.getProfileKind());
                profiles.add(eclipseProfile);
                store.writeProfiles(profiles, instanceScope);
                instanceScope.getNode("org.eclipse.jdt.ui").flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    instanceScope.getNode("org.eclipse.jdt.core").flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
        }
        finally {
            try {
                instanceScope.getNode("org.eclipse.jdt.core").flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private boolean isFirstStartup() {
        IScopeContext[] scopes = new IScopeContext[]{new InstanceScope()};
        return !Platform.getPreferencesService().getBoolean(PLUGIN_ID, FIRST_STARTUP_COMPLETE, false, scopes);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.registerImage(reg, IMG_LIFERAY_ICON_SMALL, "/icons/liferay_logo_16.png");
    }

    protected void registerImage(ImageRegistry registry, String key, String path) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)this.getBundle().getEntry(path));
            this.imageDescriptors.put(key, id);
            registry.put(key, id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

