/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.core.dd;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.hook.core.operation.INewHookDataModelProperties;
import com.liferay.ide.project.core.descriptor.LiferayDescriptorHelper;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class HookDescriptorHelper
extends LiferayDescriptorHelper
implements INewHookDataModelProperties {
    public static final String DESCRIPTOR_FILE = "liferay-hook.xml";
    private static final String HOOK_DESCRIPTOR_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE hook PUBLIC \"-//Liferay//DTD Hook {0}//EN\" \"http://www.liferay.com/dtd/liferay-hook_{1}.dtd\">\n\n<hook>\n</hook>";

    public HookDescriptorHelper(IProject project) {
        super(project);
    }

    public IStatus addActionItems(final List<String[]> actionItems) {
        IFile descriptorFile = this.getDescriptorFile();
        LiferayDescriptorHelper.DOMModelEditOperation operation = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

            protected void createDefaultFile() {
                this.createDefaultDescriptor(HookDescriptorHelper.HOOK_DESCRIPTOR_TEMPLATE, HookDescriptorHelper.this.getDescriptorVersion());
            }

            protected IStatus doExecute(IDOMDocument document) {
                return HookDescriptorHelper.this.doAddActionItems(document, actionItems);
            }
        };
        IStatus status = operation.execute();
        if (!status.isOK()) {
            return status;
        }
        return status;
    }

    protected void addDescriptorOperations() {
    }

    public IStatus addLanguageProperties(final List<String> languageProperties) {
        IFile descriptorFile = this.getDescriptorFile();
        LiferayDescriptorHelper.DOMModelEditOperation operation = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

            protected void createDefaultFile() {
                this.createDefaultDescriptor(HookDescriptorHelper.HOOK_DESCRIPTOR_TEMPLATE, HookDescriptorHelper.this.getDescriptorVersion());
            }

            protected IStatus doExecute(IDOMDocument document) {
                return HookDescriptorHelper.this.doAddLanguageProperties(document, languageProperties);
            }
        };
        IStatus status = operation.execute();
        if (!status.isOK()) {
            return status;
        }
        return status;
    }

    public void createDefaultDescriptor() {
        IFile descriptorFile = this.getDescriptorFile();
        LiferayDescriptorHelper.DOMModelEditOperation operation = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

            protected void createDefaultFile() {
                this.createDefaultDescriptor(HookDescriptorHelper.HOOK_DESCRIPTOR_TEMPLATE, HookDescriptorHelper.this.getDescriptorVersion());
            }

            protected IStatus doExecute(IDOMDocument document) {
                return Status.OK_STATUS;
            }
        };
        operation.execute();
    }

    protected IStatus doAddActionItems(IDOMDocument document, List<String[]> actionItems) {
        Element rootElement = document.getDocumentElement();
        FormatProcessorXML processor = new FormatProcessorXML();
        Element newServiceElement = null;
        if (actionItems != null) {
            for (String[] actionItem : actionItems) {
                newServiceElement = NodeUtil.appendChildElement((Element)rootElement, (String)"service");
                NodeUtil.appendChildElement((Element)newServiceElement, (String)"service-type", (String)actionItem[0]);
                NodeUtil.appendChildElement((Element)newServiceElement, (String)"service-impl", (String)actionItem[1]);
                processor.formatNode((Node)newServiceElement);
            }
            if (newServiceElement != null) {
                rootElement.appendChild(document.createTextNode(System.getProperty("line.separator")));
                processor.formatNode((Node)newServiceElement);
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus doAddLanguageProperties(IDOMDocument document, List<String> languageProperties) {
        Element rootElement = document.getDocumentElement();
        FormatProcessorXML processor = new FormatProcessorXML();
        Element newLanguageElement = null;
        Node refChild = null;
        NodeList nodeList = rootElement.getElementsByTagName("custom-jsp-dir");
        if (nodeList != null && nodeList.getLength() > 0) {
            refChild = nodeList.item(0);
        } else {
            nodeList = rootElement.getElementsByTagName("service");
            if (nodeList != null && nodeList.getLength() > 0) {
                refChild = nodeList.item(0);
            }
        }
        if (languageProperties != null) {
            for (String languageProperty : languageProperties) {
                newLanguageElement = NodeUtil.insertChildElement((Element)rootElement, (Node)refChild, (String)"language-properties", (String)languageProperty);
                processor.formatNode((Node)newLanguageElement);
            }
            if (newLanguageElement != null) {
                rootElement.appendChild(document.createTextNode(System.getProperty("line.separator")));
                processor.formatNode((Node)newLanguageElement);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus doSetCustomJSPDir(IDOMDocument document, IDataModel model) {
        Element rootElement = document.getDocumentElement();
        String customJSPsFolder = model.getStringProperty("INewHookDataModelProperties.CUSTOM_JSPS_FOLDER");
        IWebProject lrproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)this.project);
        if (lrproject != null) {
            IPath defaultWebappRootFolderFullPath = lrproject.getDefaultDocrootFolder().getFullPath();
            String relativeJspFolderPath = ProjectUtil.getRelativePathFromDocroot((IWebProject)lrproject, (String)defaultWebappRootFolderFullPath.append(customJSPsFolder).toPortableString());
            Element customJspElement = null;
            NodeList nodeList = rootElement.getElementsByTagName("custom-jsp-dir");
            if (nodeList != null && nodeList.getLength() > 0) {
                customJspElement = (Element)nodeList.item(0);
                NodeUtil.removeChildren((Element)customJspElement);
                Text textNode = document.createTextNode(relativeJspFolderPath);
                customJspElement.appendChild(textNode);
            } else {
                NodeList serviceTags = rootElement.getElementsByTagName("service");
                if (serviceTags != null && serviceTags.getLength() > 0) {
                    customJspElement = NodeUtil.insertChildElement((Element)rootElement, (Node)serviceTags.item(0), (String)"custom-jsp-dir", (String)relativeJspFolderPath);
                } else {
                    customJspElement = NodeUtil.appendChildElement((Element)rootElement, (String)"custom-jsp-dir", (String)relativeJspFolderPath);
                    rootElement.appendChild(document.createTextNode(System.getProperty("line.separator")));
                }
            }
            FormatProcessorXML processor = new FormatProcessorXML();
            processor.formatNode((Node)customJspElement);
        }
        return Status.OK_STATUS;
    }

    protected IStatus doSetPortalProperties(IDOMDocument document, IDataModel model, String propertiesFile) {
        Element rootElement = document.getDocumentElement();
        Element portalPropertiesElement = null;
        NodeList nodeList = rootElement.getElementsByTagName("portal-properties");
        if (nodeList != null && nodeList.getLength() > 0) {
            portalPropertiesElement = (Element)nodeList.item(0);
            NodeUtil.removeChildren((Element)portalPropertiesElement);
            Text textNode = document.createTextNode(propertiesFile);
            portalPropertiesElement.appendChild(textNode);
        } else {
            portalPropertiesElement = NodeUtil.insertChildElement((Element)rootElement, (Node)rootElement.getFirstChild(), (String)"portal-properties", (String)propertiesFile);
        }
        FormatProcessorXML processor = new FormatProcessorXML();
        processor.formatNode((Node)portalPropertiesElement);
        return Status.OK_STATUS;
    }

    public String getCustomJSPFolder(final IDataModel model) {
        final String[] retval = new String[1];
        IFile descriptorFile = this.getDescriptorFile();
        if (descriptorFile == null || !descriptorFile.exists()) {
            return null;
        }
        LiferayDescriptorHelper.DOMModelReadOperation operation = new LiferayDescriptorHelper.DOMModelReadOperation(this, descriptorFile){

            protected IStatus doExecute(IDOMDocument document) {
                retval[0] = HookDescriptorHelper.this.readCustomJSPFolder(document, model);
                return Status.OK_STATUS;
            }
        };
        IStatus status = operation.execute();
        if (!status.isOK()) {
            return null;
        }
        return retval[0];
    }

    public IFile getDescriptorFile() {
        return super.getDescriptorFile(DESCRIPTOR_FILE);
    }

    public String readCustomJSPFolder(IDOMDocument document, IDataModel model) {
        Element rootElement = document.getDocumentElement();
        Element customJspElement = null;
        NodeList nodeList = rootElement.getElementsByTagName("custom-jsp-dir");
        if (nodeList != null && nodeList.getLength() > 0) {
            customJspElement = (Element)nodeList.item(0);
            return customJspElement.getFirstChild().getNodeValue();
        }
        return null;
    }

    public IStatus setCustomJSPDir(final IDataModel model) {
        IFile descriptorFile = this.getDescriptorFile();
        LiferayDescriptorHelper.DOMModelEditOperation operation = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

            protected void createDefaultFile() {
                this.createDefaultDescriptor(HookDescriptorHelper.HOOK_DESCRIPTOR_TEMPLATE, HookDescriptorHelper.this.getDescriptorVersion());
            }

            protected IStatus doExecute(IDOMDocument document) {
                return HookDescriptorHelper.this.doSetCustomJSPDir(document, model);
            }
        };
        IStatus status = operation.execute();
        if (!status.isOK()) {
            return status;
        }
        return status;
    }

    public IStatus setPortalProperties(final IDataModel model, final String propertiesFile) {
        IFile descriptorFile = this.getDescriptorFile();
        LiferayDescriptorHelper.DOMModelEditOperation operation = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

            protected void createDefaultFile() {
                this.createDefaultDescriptor(HookDescriptorHelper.HOOK_DESCRIPTOR_TEMPLATE, HookDescriptorHelper.this.getDescriptorVersion());
            }

            protected IStatus doExecute(IDOMDocument document) {
                return HookDescriptorHelper.this.doSetPortalProperties(document, model, propertiesFile);
            }
        };
        IStatus status = operation.execute();
        if (!status.isOK()) {
            return status;
        }
        return status;
    }
}

