/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.core.model.internal;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.hook.core.HookCore;
import com.liferay.ide.hook.core.model.Hook;
import com.liferay.ide.hook.core.util.HookUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class CustomJspValidationService
extends ValidationService {
    private IPath portalDir;

    private IPath getPortalDir() {
        if (this.portalDir == null) {
            try {
                ILiferayPortal portal;
                Element element = (Element)this.context().find(Element.class);
                IProject project = ((IFile)((Hook)element.nearest(Hook.class)).adapt(IFile.class)).getProject();
                ILiferayProject liferayProject = LiferayCore.create((Object)project);
                if (liferayProject != null && (portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class)) != null) {
                    this.portalDir = portal.getAppServerPortalDir();
                }
            }
            catch (Exception e) {
                HookCore.logError(e);
            }
        }
        return this.portalDir;
    }

    private boolean isValidPortalJsp(Value<?> value) {
        String customJsp = value.content().toString();
        IPath customJspPath = this.getPortalDir().append(customJsp);
        return customJspPath != null && customJspPath.toFile().exists();
    }

    private boolean isValidProjectJsp(Value<?> value) {
        IFile customJspFile;
        String customJsp = value.content().toString();
        IFolder customFolder = HookUtil.getCustomJspFolder(this.hook(), this.project());
        return customFolder != null && customFolder.exists() && (customJspFile = customFolder.getFile(customJsp)).exists();
    }

    protected Hook hook() {
        return (Hook)this.context().find(Hook.class);
    }

    protected IProject project() {
        return (IProject)this.hook().adapt(IProject.class);
    }

    private boolean isValueEmpty(Value<?> value) {
        return value.content(false) == null;
    }

    public Status compute() {
        Value value = (Value)((Element)this.context(Element.class)).property(((Property)this.context(Property.class)).definition());
        ValueProperty property = value.definition();
        String label = property.getLabel(true, CapitalizationType.NO_CAPS, false);
        if (this.isValueEmpty(value)) {
            String msg = NLS.bind((String)Msgs.nonEmptyValueRequired, (Object)label);
            return Status.createErrorStatus((String)msg);
        }
        if (!this.isValidPortalJsp(value) && !this.isValidProjectJsp(value)) {
            String msg = NLS.bind((String)Msgs.customJspInvalidPath, (Object)label);
            return Status.createErrorStatus((String)msg);
        }
        return Status.createOkStatus();
    }

    private static class Msgs
    extends NLS {
        public static String customJspInvalidPath;
        public static String nonEmptyValueRequired;

        static {
            Msgs.initializeMessages((String)CustomJspValidationService.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

