/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.action;

import com.liferay.ide.kaleo.core.model.Node;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.PropertyEditorActionHandler;

public abstract class DefaultListAddActionHandler
extends PropertyEditorActionHandler {
    private final ElementType type;
    private final ListProperty property;

    public DefaultListAddActionHandler(ElementType type, ListProperty property) {
        this.type = type;
        this.property = property;
    }

    public static String getDefaultName(String initialName, Node newNode, Node[] nodes) {
        String newName = initialName;
        int count = 1;
        boolean newNameIsValid = false;
        do {
            newNameIsValid = true;
            Node[] nodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                if (newName.equals(node.getName().content())) {
                    newNameIsValid = false;
                    break;
                }
                ++n2;
            }
            if (newNameIsValid) continue;
            newName = String.valueOf(newName.replace(Integer.toString(count), "")) + ++count;
        } while (!newNameIsValid);
        return newName;
    }

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        ImageData typeSpecificAddImage = this.type.image();
        if (typeSpecificAddImage != null) {
            this.addImage(typeSpecificAddImage);
        }
        this.setLabel(this.type.getLabel(false, CapitalizationType.TITLE_STYLE, false));
    }

    public final ElementList<Element> getList() {
        Element modelElement = this.getModelElement();
        if (modelElement != null) {
            return modelElement.property(this.property);
        }
        return null;
    }

    protected Object run(Presentation context) {
        return this.getList().insert(this.type);
    }
}

