/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.diagram;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.kaleo.core.model.Action;
import com.liferay.ide.kaleo.core.model.CanTransition;
import com.liferay.ide.kaleo.core.model.ScriptLanguageType;
import com.liferay.ide.kaleo.core.model.State;
import com.liferay.ide.kaleo.core.model.Transition;
import com.liferay.ide.kaleo.core.op.NewNodeOp;
import com.liferay.ide.kaleo.core.op.NewStateNode;
import com.liferay.ide.kaleo.core.op.NewStateNodeOp;
import com.liferay.ide.kaleo.core.op.NewStateType;
import com.liferay.ide.kaleo.core.util.KaleoModelUtil;
import com.liferay.ide.kaleo.ui.IKaleoEditorHelper;
import com.liferay.ide.kaleo.ui.KaleoUI;
import com.liferay.ide.kaleo.ui.diagram.NewNodeAddActionHandler;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;

public class StateNodeAddActionHandler
extends NewNodeAddActionHandler {
    private static final String WIZARD_ID = "newStateNodeWizard";

    public StateNodeAddActionHandler(DiagramNodeTemplate nodeTemplate) {
        super(nodeTemplate);
    }

    @Override
    protected NewNodeOp createOp(Presentation context) {
        return (NewNodeOp)NewStateNodeOp.TYPE.instantiate();
    }

    @Override
    protected String getWizardId() {
        return WIZARD_ID;
    }

    @Override
    public void postDiagramNodePartAdded(NewNodeOp op, CanTransition newNodeFromWizard, CanTransition newNode) {
        NewStateNodeOp newStateNodeOp = (NewStateNodeOp)op.nearest(NewStateNodeOp.class);
        NewStateNode newStateNode = (NewStateNode)newNodeFromWizard.nearest(NewStateNode.class);
        State state = (State)newNode.nearest(State.class);
        if (newStateNode != null && state != null) {
            state.setName((String)newStateNode.getName().content());
            NewStateType newStateType = (NewStateType)newStateNodeOp.getType().content();
            if (newStateType.equals((Object)NewStateType.START)) {
                state.setInitial(Boolean.valueOf(true));
            } else if (newStateType.equals((Object)NewStateType.END)) {
                state.setEnd(Boolean.valueOf(true));
            }
            String workflowStatus = (String)newStateNodeOp.getWorkflowStatus().content(false);
            if (!CoreUtil.empty((String)workflowStatus)) {
                Action newAction = (Action)state.getActions().insert();
                newAction.setName((String)state.getName().content());
                newAction.setScriptLanguage(KaleoModelUtil.getDefaultValue((Element)state, (QualifiedName)KaleoCore.DEFAULT_SCRIPT_LANGUAGE_KEY, (Enum)ScriptLanguageType.GROOVY));
                newAction.setExecutionType("onEntry");
                IKaleoEditorHelper editorHelper = KaleoUI.getKaleoEditorHelper(newAction.getScriptLanguage().text());
                if (editorHelper != null) {
                    try {
                        File statusUpdatesFolder = new File(FileLocator.toFileURL((URL)Platform.getBundle((String)editorHelper.getContributorName()).getEntry("palette/Status Updates")).getFile());
                        File statusSnippet = new File(statusUpdatesFolder, String.valueOf(workflowStatus) + "." + editorHelper.getFileExtension());
                        if (statusSnippet.exists()) {
                            newAction.setScript(FileUtil.readContents((File)statusSnippet, (boolean)true));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!newStateType.equals((Object)NewStateType.END) && newStateNodeOp.getExitTransitionName().content() != null) {
                Transition newTransition = (Transition)state.getTransitions().insert();
                newTransition.setTarget((String)newStateNodeOp.getExitTransitionName().content());
                newTransition.setName((String)newStateNodeOp.getExitTransitionName().content());
            }
        }
    }
}

