/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.diagram;

import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.kaleo.core.model.Action;
import com.liferay.ide.kaleo.core.model.ActionNotification;
import com.liferay.ide.kaleo.core.model.CanTransition;
import com.liferay.ide.kaleo.core.model.ExecutionType;
import com.liferay.ide.kaleo.core.model.ScriptLanguageType;
import com.liferay.ide.kaleo.core.model.Task;
import com.liferay.ide.kaleo.core.model.TemplateLanguageType;
import com.liferay.ide.kaleo.core.op.AssignableOp;
import com.liferay.ide.kaleo.core.op.NewNodeOp;
import com.liferay.ide.kaleo.core.op.NewTaskNode;
import com.liferay.ide.kaleo.core.op.NewTaskNodeOp;
import com.liferay.ide.kaleo.core.util.KaleoModelUtil;
import com.liferay.ide.kaleo.ui.diagram.NewNodeAddActionHandler;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;

public class TaskNodeAddActionHandler
extends NewNodeAddActionHandler {
    private static final String WIZARD_ID = "newTaskNodeWizard";

    public TaskNodeAddActionHandler(DiagramNodeTemplate nodeTemplate) {
        super(nodeTemplate);
    }

    @Override
    protected NewNodeOp createOp(Presentation context) {
        NewTaskNodeOp op = (NewTaskNodeOp)NewTaskNodeOp.TYPE.instantiate();
        op.getImpliedScriptable().setScriptLanguage(KaleoModelUtil.getDefaultValue((Element)this.getModelElement(), (QualifiedName)KaleoCore.DEFAULT_SCRIPT_LANGUAGE_KEY, (Enum)ScriptLanguageType.GROOVY));
        return op;
    }

    @Override
    protected String getWizardId() {
        return WIZARD_ID;
    }

    @Override
    public void postDiagramNodePartAdded(NewNodeOp op, CanTransition newNodeFromWizard, CanTransition newNode) {
        Task newTask = (Task)newNode.nearest(Task.class);
        NewTaskNode newTaskFromWizard = (NewTaskNode)newNodeFromWizard.nearest(NewTaskNode.class);
        KaleoModelUtil.changeTaskAssignments((Task)newTask, (AssignableOp)((AssignableOp)op.nearest(AssignableOp.class)));
        for (Action taskAction : newTaskFromWizard.getTaskActions()) {
            ((Action)newTask.getTaskActions().insert()).copy((Element)taskAction);
        }
        for (NewTaskNode.INewTaskNotification taskNotification : newTaskFromWizard.getNewTaskNotifications()) {
            ActionNotification newTaskNotification = (ActionNotification)newTask.getTaskNotifications().insert();
            newTaskNotification.setName((String)taskNotification.getName().content());
            newTaskNotification.setExecutionType((ExecutionType)taskNotification.getExecutionType().content());
            newTaskNotification.setTemplateLanguage((TemplateLanguageType)taskNotification.getTemplateLanguage().content());
        }
    }
}

