/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.editor;

import com.liferay.ide.kaleo.ui.IKaleoEditorHelper;
import com.liferay.ide.kaleo.ui.KaleoUI;
import com.liferay.ide.kaleo.ui.editor.DefaultScriptEditorHelper;
import com.liferay.ide.kaleo.ui.editor.ScriptPropertyEditorInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.listeners.ValuePropertyEditorListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class ScriptPropertyEditorRenderer
extends PropertyEditorPresentation {
    private IEditorPart editorPart;

    public ScriptPropertyEditorRenderer(FormComponentPart part, SwtPresentation context, Composite composite) {
        super(part, context, composite);
    }

    protected boolean canScaleVertically() {
        return true;
    }

    protected void createContents(Composite parent) {
        PropertyEditorPart part = this.part();
        final Element element = part.getLocalModelElement();
        final ValueProperty property = (ValueProperty)part.property().nearest(ValueProperty.class);
        Composite codeEditorParent = this.createMainComposite(parent, new PropertyEditorPresentation.CreateMainCompositeDelegate(this, part){

            public boolean canScaleVertically() {
                return true;
            }
        });
        int codeEditorParentColumns = 1;
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(this.getActionPresentationManager());
        boolean isActionsToolBarNeeded = toolBarActionsPresentation.hasActions();
        if (isActionsToolBarNeeded) {
            ++codeEditorParentColumns;
        }
        codeEditorParent.setLayout((Layout)GridLayoutUtil.glayout((int)codeEditorParentColumns, (int)0, (int)0, (int)0, (int)0));
        Composite nestedComposite = new Composite(codeEditorParent, 0);
        nestedComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.addControl((Control)nestedComposite);
        PropertyEditorAssistDecorator decorator = this.createDecorator(nestedComposite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign((GridData)GridLayoutUtil.gd(), (int)128));
        decorator.addEditorControl((Control)nestedComposite);
        ScriptPropertyEditorInput editorInput = new ScriptPropertyEditorInput(element, property);
        ArrayList<ToolBar> relatedControls = new ArrayList<ToolBar>();
        try {
            IEditorSite editorSite = (IEditorSite)this.part().adapt(IEditorSite.class);
            this.editorPart = this.createEditorPart(editorInput, editorSite);
            this.editorPart.createPartControl(nestedComposite);
            Control editorControl = (Control)this.editorPart.getAdapter(Control.class);
            Object editorControlParent = null;
            Control control = editorControl;
            while (editorControlParent == null && control != null && !nestedComposite.equals(control.getParent())) {
                control = control.getParent();
            }
            nestedComposite.setLayout((Layout)GridLayoutUtil.glspacing((GridLayout)GridLayoutUtil.glayout((int)2, (int)0, (int)0), (int)2));
            control.setLayoutData((Object)GridLayoutUtil.gdfill());
            decorator.addEditorControl(editorControl, true);
            editorControl.setData("related-controls", relatedControls);
        }
        catch (Exception e) {
            KaleoUI.logError(e);
        }
        if (isActionsToolBarNeeded) {
            ToolBar toolbar = new ToolBar(codeEditorParent, 0x800100);
            toolbar.setLayoutData((Object)GridLayoutUtil.gdvfill());
            toolBarActionsPresentation.setToolBar(toolbar);
            toolBarActionsPresentation.render();
            this.addControl((Control)toolbar);
            decorator.addEditorControl((Control)toolbar);
            relatedControls.add(toolbar);
        }
        List listenerClasses = (List)part.getRenderingHint("listeners", Collections.emptyList());
        final ArrayList<ValuePropertyEditorListener> listeners = new ArrayList<ValuePropertyEditorListener>();
        if (!listenerClasses.isEmpty()) {
            for (Class cl : listenerClasses) {
                try {
                    ValuePropertyEditorListener listener = (ValuePropertyEditorListener)cl.newInstance();
                    listener.initialize((PropertyEditorPresentation)this);
                    listeners.add(listener);
                }
                catch (Exception e) {
                    KaleoUI.logError(e);
                }
            }
        }
        ITextEditor textEditor = null;
        textEditor = this.editorPart instanceof ITextEditor ? (ITextEditor)this.editorPart : (ITextEditor)this.editorPart.getAdapter(ITextEditor.class);
        this.addControl((Control)textEditor.getAdapter(Control.class));
        textEditor.getDocumentProvider().getDocument((Object)this.editorPart.getEditorInput()).addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                element.property(property).write((Object)event.getDocument().get());
                if (!listeners.isEmpty()) {
                    for (ValuePropertyEditorListener listener : listeners) {
                        try {
                            listener.handleValueChanged();
                        }
                        catch (Exception e) {
                            KaleoUI.logError(e);
                        }
                    }
                }
            }
        });
    }

    protected IEditorPart createEditorPart(ScriptPropertyEditorInput editorInput, IEditorSite editorSite) {
        IKaleoEditorHelper scriptEditorHelper = KaleoUI.getKaleoEditorHelper(editorInput.getScriptLanguage());
        if (scriptEditorHelper == null) {
            scriptEditorHelper = new DefaultScriptEditorHelper();
        }
        return scriptEditorHelper.createEditorPart(editorInput, editorSite);
    }

    public static final class Factory
    extends PropertyEditorPresentationFactory {
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            return new ScriptPropertyEditorRenderer((FormComponentPart)part, parent, composite);
        }
    }
}

