/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.navigator;

import com.liferay.ide.kaleo.core.KaleoAPIException;
import com.liferay.ide.kaleo.ui.KaleoImages;
import com.liferay.ide.kaleo.ui.navigator.WorkflowDefinitionEntry;
import com.liferay.ide.kaleo.ui.navigator.WorkflowDefinitionsFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class WorkflowDefinitionsDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static WorkflowDefinitionsDecorator instance;
    private static final String WORKFLOW_DEFINITIONS_FOLDER_NAME = "Kaleo Workflows";

    public static WorkflowDefinitionsDecorator getDefault() {
        return instance;
    }

    protected String combine(int version, int draftVersion) {
        if (draftVersion == -1) {
            return "  [Version: " + version + "]";
        }
        return "  [Version: " + version + ", Draft Version: " + draftVersion + "]";
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof WorkflowDefinitionEntry) {
            WorkflowDefinitionEntry definition = (WorkflowDefinitionEntry)element;
            if (!definition.isLoadingNode()) {
                int version = definition.getVersion();
                int draftVersion = definition.getDraftVersion();
                decoration.addSuffix(this.combine(version, draftVersion));
            }
        } else if (element instanceof WorkflowDefinitionsFolder) {
            WorkflowDefinitionsFolder folder = (WorkflowDefinitionsFolder)element;
            IStatus status = folder.getStatus();
            if (status != null) {
                if (status.getException() instanceof KaleoAPIException) {
                    decoration.addSuffix("  [Error API unavailable. Ensure kaleo-designer-portlet is deployed.]");
                    decoration.addOverlay(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR"));
                } else {
                    decoration.addSuffix("  [" + status.getMessage() + "]");
                }
            } else {
                decoration.addSuffix("");
            }
        }
    }

    public Image getImage(Object element) {
        if (element instanceof WorkflowDefinitionsFolder) {
            return KaleoImages.IMG_WORKFLOW_DEFINITIONS_FOLDER;
        }
        if (element instanceof WorkflowDefinitionEntry) {
            WorkflowDefinitionEntry definition = (WorkflowDefinitionEntry)element;
            if (definition.isLoadingNode()) {
                return KaleoImages.IMG_LOADING;
            }
            return KaleoImages.IMG_WORKFLOW_DEFINITION;
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof WorkflowDefinitionsFolder) {
            return new StyledString(WORKFLOW_DEFINITIONS_FOLDER_NAME);
        }
        if (element instanceof WorkflowDefinitionEntry) {
            WorkflowDefinitionEntry definitionNode = (WorkflowDefinitionEntry)element;
            return new StyledString(definitionNode.getName());
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof WorkflowDefinitionsFolder) {
            return WORKFLOW_DEFINITIONS_FOLDER_NAME;
        }
        if (element instanceof WorkflowDefinitionEntry) {
            WorkflowDefinitionEntry definitionNode = (WorkflowDefinitionEntry)element;
            return definitionNode.getName();
        }
        return null;
    }
}

