/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.util;

import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.server.core.ILiferayServer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.validation.ValidationResults;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.ValidationRunner;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class KaleoUtil {
    public static String checkWorkflowDefinitionForErrors(IFile workspaceFile) {
        String retval = null;
        try {
            StringBuilder errorMsgs = new StringBuilder();
            ValOperation result = ValidationRunner.validate((IFile)workspaceFile, (ValType)ValType.Manual, null, (boolean)true);
            if (result.getResult().getSeverityError() == 1) {
                ValidationResults results = result.getResults();
                ValidatorMessage[] validatorMessageArray = results.getMessages();
                int n = validatorMessageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ValidatorMessage message = validatorMessageArray[n2];
                    if (message.getAttribute("severity", -1) == 2) {
                        errorMsgs.append(message.getAttribute("message")).append('\n');
                    }
                    ++n2;
                }
            }
            retval = errorMsgs.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public static String createJSONTitleMap(String title) throws JSONException {
        return KaleoUtil.createJSONTitleMap(title, Locale.getDefault().toString());
    }

    public static String createJSONTitleMap(String title, String portalLocale) throws JSONException {
        JSONObject jsonTitleMap = new JSONObject();
        try {
            Document doc = FileUtil.readXML((InputStream)new ByteArrayInputStream(title.getBytes()), null, (ErrorHandler)new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                }
            });
            String defaultLocale = doc.getDocumentElement().getAttribute("default-locale");
            NodeList titles = doc.getElementsByTagName("Title");
            int i = 0;
            while (i < titles.getLength()) {
                Node titleNode = titles.item(i);
                String titleValue = titleNode.getTextContent();
                String languageId = titleNode.getAttributes().getNamedItem("language-id").getNodeValue();
                if (languageId.equals(defaultLocale)) {
                    jsonTitleMap.put(languageId, (Object)titleValue);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            jsonTitleMap.put(portalLocale, (Object)title);
        }
        return jsonTitleMap.toString();
    }

    public static ILiferayServer getLiferayServer(IServer server, IProgressMonitor monitor) {
        ILiferayServer retval = null;
        if (server != null) {
            try {
                retval = (ILiferayServer)server.loadAdapter(ILiferayServer.class, monitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }
}

