/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core.op.internal;

import com.liferay.ide.kaleo.core.model.User;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class UserValidationService
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        User user = (User)this.context(User.class);
        if (user != null) {
            this.listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    UserValidationService.this.refresh();
                }
            };
            user.attach(this.listener, "*");
        }
    }

    public void dispose() {
        User user = (User)this.context(User.class);
        if (user != null) {
            user.detach(this.listener);
        }
    }

    public Status compute() {
        User user = (User)this.context(User.class);
        if (user != null) {
            boolean emailAddress;
            int count = 0;
            boolean userId = user.getUserId().content() != null;
            boolean screenName = user.getScreenName().content() != null;
            boolean bl = emailAddress = user.getEmailAddress().content() != null;
            if (userId) {
                ++count;
            }
            if (screenName) {
                ++count;
            }
            if (emailAddress) {
                ++count;
            }
            if (count > 1) {
                return Status.createErrorStatus((String)"Only specify one of the three user fields.");
            }
        }
        return Status.createOkStatus();
    }
}

