/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core.util;

import com.liferay.ide.kaleo.core.model.AssignmentType;
import com.liferay.ide.kaleo.core.model.ResourceAction;
import com.liferay.ide.kaleo.core.model.Role;
import com.liferay.ide.kaleo.core.model.RoleType;
import com.liferay.ide.kaleo.core.model.ScriptLanguageType;
import com.liferay.ide.kaleo.core.model.Scriptable;
import com.liferay.ide.kaleo.core.model.Task;
import com.liferay.ide.kaleo.core.model.User;
import com.liferay.ide.kaleo.core.model.WorkflowDefinition;
import com.liferay.ide.kaleo.core.model.internal.Point;
import com.liferay.ide.kaleo.core.op.AssignableOp;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.annotations.EnumSerialization;

public class KaleoModelUtil {
    public static final Point DEFAULT_POINT = new Point(-1, -1);

    public static void changeTaskAssignments(Task task, AssignableOp op) {
        if (task == null || op == null) {
            return;
        }
        task.getUser().clear();
        task.getScriptedAssignment().clear();
        task.getResourceActions().clear();
        task.getRoles().clear();
        switch ((AssignmentType)((Object)op.getAssignmentType().content(true))) {
            case CREATOR: {
                task.getUser().content(true);
                break;
            }
            case USER: {
                ((User)task.getUser().content(true)).copy(op.getImpliedUser());
                break;
            }
            case ROLE: {
                Role newRole = (Role)task.getRoles().insert();
                newRole.copy(op.getImpliedRole());
                break;
            }
            case ROLE_TYPE: {
                for (Role role : op.getRoles()) {
                    Role newRoleType = (Role)task.getRoles().insert();
                    newRoleType.copy(role);
                    newRoleType.setRoleType((RoleType)((Object)role.getRoleType().content(true)));
                    if (role.getAutoCreate().content() == null) continue;
                    newRoleType.setAutoCreate((Boolean)role.getAutoCreate().content());
                }
                break;
            }
            case SCRIPTED_ASSIGNMENT: {
                Scriptable scriptable = (Scriptable)task.getScriptedAssignment().content(true);
                scriptable.setScriptLanguage((ScriptLanguageType)((Object)op.getImpliedScriptable().getScriptLanguage().content(true)));
                scriptable.setScript("/*specify script assignment */");
                break;
            }
            case RESOURCE_ACTIONS: {
                for (ResourceAction ra : op.getResourceActions()) {
                    ((ResourceAction)task.getResourceActions().insert()).copy(ra);
                }
                break;
            }
        }
    }

    public static String getEnumSerializationAnnotation(Enum<?> type) {
        try {
            return type.getClass().getField(type.name()).getAnnotation(EnumSerialization.class).primary();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getDefaultValue(Element modelElement, QualifiedName key, Enum<?> defaultValue) {
        String value = null;
        IFile definitionFile = null;
        WorkflowDefinition workflowDefinition = (WorkflowDefinition)modelElement.nearest(WorkflowDefinition.class);
        if (workflowDefinition == null) {
            workflowDefinition = (WorkflowDefinition)modelElement.adapt(WorkflowDefinition.class);
        }
        if (workflowDefinition != null) {
            definitionFile = (IFile)workflowDefinition.adapt(IFile.class);
        }
        if (definitionFile != null) {
            try {
                value = definitionFile.getPersistentProperty(key);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (value == null) {
            value = KaleoModelUtil.getEnumSerializationAnnotation(defaultValue);
        }
        return value;
    }
}

