/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.listener.awt;

import java.awt.EventQueue;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.internal.queue.SynchronizedQueue;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;

public final class AWTStateChangeListenerWrapper
implements StateChangeListener {
    private final StateChangeListener listener;
    private final SynchronizedQueue<StateChangeEvent> events = QueueTools.synchronizedQueue();

    public AWTStateChangeListenerWrapper(StateChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    @Override
    public void stateChanged(StateChangeEvent event) {
        this.events.enqueue(event);
        if (this.isExecutingOnUIThread()) {
            this.forwardEvents();
        } else {
            this.executeOnEventQueue(new ForwardEventsRunnable());
        }
    }

    private boolean isExecutingOnUIThread() {
        return EventQueue.isDispatchThread();
    }

    private void executeOnEventQueue(Runnable r) {
        EventQueue.invokeLater(r);
    }

    void forwardEvents() {
        for (StateChangeEvent event : this.events.drain()) {
            this.listener.stateChanged(event);
        }
    }

    public String toString() {
        return "AWT(" + this.listener.toString() + ')';
    }

    class ForwardEventsRunnable
    extends RunnableAdapter {
        ForwardEventsRunnable() {
        }

        @Override
        public void run() {
            AWTStateChangeListenerWrapper.this.forwardEvents();
        }
    }
}

