/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.core.operation;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.project.core.descriptor.IDescriptorOperation;
import com.liferay.ide.project.core.descriptor.LiferayDescriptorHelper;
import com.liferay.ide.project.core.descriptor.RemoveSampleElementsOperation;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceBuilderDescriptorHelper
extends LiferayDescriptorHelper {
    private static final String DESCRIPTOR_FILE = "service.xml";
    private final String NEW_LINE = System.getProperty("line.separator");

    public ServiceBuilderDescriptorHelper() {
    }

    public ServiceBuilderDescriptorHelper(IProject project) {
        super(project);
    }

    public IStatus addDefaultColumns(final String elementName) {
        IFile descriptorFile = this.getDescriptorFile();
        LiferayDescriptorHelper.DOMModelEditOperation editOperation = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

            protected IStatus doExecute(IDOMDocument document) {
                return ServiceBuilderDescriptorHelper.this.doAddDefaultColumns(document, elementName);
            }
        };
        return editOperation.execute();
    }

    public IStatus addDefaultEntity() {
        IStatus status = Status.OK_STATUS;
        IFile descriptorFile = this.getDescriptorFile();
        if (descriptorFile != null) {
            LiferayDescriptorHelper.DOMModelEditOperation editOperation = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

                protected IStatus doExecute(IDOMDocument document) {
                    return ServiceBuilderDescriptorHelper.this.doAddDefaultEntity(document);
                }
            };
            status = editOperation.execute();
        }
        return status;
    }

    protected void addDescriptorOperations() {
        this.addDescriptorOperation((IDescriptorOperation)new RemoveSampleElementsOperation(){

            public IStatus removeSampleElements() {
                return ServiceBuilderDescriptorHelper.this.removeAllEntities();
            }
        });
    }

    public IStatus addEntity(final String entityName) {
        IFile descriptorFile = this.getDescriptorFile();
        if (descriptorFile == null || !descriptorFile.exists()) {
            return Status.OK_STATUS;
        }
        LiferayDescriptorHelper.DOMModelEditOperation editOperation = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

            protected IStatus doExecute(IDOMDocument document) {
                return ServiceBuilderDescriptorHelper.this.doAddEntity(document, entityName);
            }
        };
        return editOperation.execute();
    }

    private void appendComment(Element element, String comment) {
        Document document = element.getOwnerDocument();
        element.appendChild(document.createTextNode(String.valueOf(this.NEW_LINE) + this.NEW_LINE));
        element.appendChild(document.createComment(comment));
        element.appendChild(document.createTextNode(String.valueOf(this.NEW_LINE) + this.NEW_LINE));
    }

    protected IStatus doAddDefaultColumns(IDOMDocument document, String entityName) {
        Element entityElement = null;
        NodeList nodes = document.getDocumentElement().getChildNodes();
        if (nodes != null && nodes.getLength() > 0) {
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeName().equals("entity") && node instanceof Element && entityName.equals(((Element)node).getAttribute("name"))) {
                    entityElement = (Element)node;
                }
                ++i;
            }
        }
        if (entityElement == null) {
            return Status.CANCEL_STATUS;
        }
        this.appendComment(entityElement, " PK fields ");
        Element columnElem = NodeUtil.appendChildElement(entityElement, (String)"column");
        columnElem.setAttribute("name", this.generateEntityId(entityName));
        columnElem.setAttribute("type", "long");
        columnElem.setAttribute("primary", "true");
        this.appendComment(entityElement, " Group instance ");
        columnElem = NodeUtil.appendChildElement(entityElement, (String)"column");
        columnElem.setAttribute("name", "groupId");
        columnElem.setAttribute("type", "long");
        this.appendComment(entityElement, " Audit fields ");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "companyId");
        columnElem.setAttribute("type", "long");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "userId");
        columnElem.setAttribute("type", "long");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "userName");
        columnElem.setAttribute("type", "String");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "createDate");
        columnElem.setAttribute("type", "Date");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "modifiedDate");
        columnElem.setAttribute("type", "Date");
        entityElement.appendChild(document.createTextNode(this.NEW_LINE));
        new FormatProcessorXML().formatNode((Node)entityElement);
        return Status.OK_STATUS;
    }

    protected IStatus doAddDefaultEntity(IDOMDocument document) {
        String entityName = this.generateSampleEntityName(document);
        Element rootElement = document.getDocumentElement();
        Element entityElement = document.createElement("entity");
        entityElement.setAttribute("name", entityName);
        entityElement.setAttribute("local-service", "true");
        entityElement.setAttribute("remote-service", "true");
        this.appendComment(entityElement, " PK fields ");
        Element columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", this.generateEntityId(entityName));
        columnElem.setAttribute("type", "long");
        columnElem.setAttribute("primary", "true");
        this.appendComment(entityElement, " Group instance ");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "groupId");
        columnElem.setAttribute("type", "long");
        this.appendComment(entityElement, " Audit fields ");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "companyId");
        columnElem.setAttribute("type", "long");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "userId");
        columnElem.setAttribute("type", "long");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "userName");
        columnElem.setAttribute("type", "String");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "createDate");
        columnElem.setAttribute("type", "Date");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "modifiedDate");
        columnElem.setAttribute("type", "Date");
        this.appendComment(entityElement, " Other fields ");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "field1");
        columnElem.setAttribute("type", "String");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "field2");
        columnElem.setAttribute("type", "boolean");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "field3");
        columnElem.setAttribute("type", "int");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "field4");
        columnElem.setAttribute("type", "Date");
        columnElem = NodeUtil.appendChildElement((Element)entityElement, (String)"column");
        columnElem.setAttribute("name", "field5");
        columnElem.setAttribute("type", "String");
        this.appendComment(entityElement, " Order ");
        Element orderElem = NodeUtil.appendChildElement((Element)entityElement, (String)"order");
        orderElem.setAttribute("by", "asc");
        NodeUtil.appendChildElement((Element)orderElem, (String)"order-column").setAttribute("name", "field1");
        this.appendComment(entityElement, " Finder methods ");
        Element finderElem = NodeUtil.appendChildElement((Element)entityElement, (String)"finder");
        finderElem.setAttribute("name", "Field2");
        finderElem.setAttribute("return-type", "Collection");
        NodeUtil.appendChildElement((Element)finderElem, (String)"finder-column").setAttribute("name", "field2");
        Node refNode = NodeUtil.findFirstChild((Element)rootElement, (String)"exceptions");
        if (refNode == null) {
            NodeUtil.findFirstChild((Element)rootElement, (String)"service-builder-import");
        }
        rootElement.insertBefore(entityElement, refNode);
        new FormatProcessorXML().formatNode((Node)entityElement);
        rootElement.appendChild(document.createTextNode(this.NEW_LINE));
        return Status.OK_STATUS;
    }

    protected IStatus doAddEntity(IDOMDocument document, String entityName) {
        NodeList entities = document.getElementsByTagName("entity");
        int i = 0;
        while (i < entities.getLength()) {
            String name;
            Node entity = entities.item(i);
            if (entity instanceof Element && (name = ((Element)entity).getAttribute("name")) != null && name.equals(entityName)) {
                return Status.OK_STATUS;
            }
            ++i;
        }
        Element rootElement = document.getDocumentElement();
        Element entityElement = document.createElement("entity");
        entityElement.setAttribute("name", entityName);
        Node refNode = NodeUtil.findFirstChild((Element)rootElement, (String)"exceptions");
        if (refNode == null) {
            NodeUtil.findFirstChild((Element)rootElement, (String)"service-builder-import");
        }
        rootElement.insertBefore(entityElement, refNode);
        new FormatProcessorXML().formatNode((Node)entityElement);
        rootElement.appendChild(document.createTextNode(this.NEW_LINE));
        return Status.OK_STATUS;
    }

    private String generateEntityId(String entityName) {
        if (entityName == null) {
            return "Id";
        }
        return String.valueOf(Character.toLowerCase(entityName.charAt(0))) + (entityName.length() > 1 ? entityName.substring(1) : "") + "Id";
    }

    private String generateSampleEntityName(IDOMDocument document) {
        String retval = "Sample";
        ArrayList<String> entityNames = new ArrayList<String>();
        NodeList nodes = document.getDocumentElement().getChildNodes();
        if (nodes != null && nodes.getLength() > 0) {
            Node node = null;
            int i = 0;
            while (i < nodes.getLength()) {
                String entityName;
                node = nodes.item(i);
                if ("entity".equals(node.getNodeName()) && !CoreUtil.isNullOrEmpty((String)(entityName = ((Element)node).getAttribute("name")))) {
                    entityNames.add(entityName);
                }
                ++i;
            }
        }
        while (entityNames.contains(retval)) {
            retval = this.nextSuffix(retval);
        }
        return retval;
    }

    public IFile getDescriptorFile() {
        return super.getDescriptorFile(DESCRIPTOR_FILE);
    }

    private String nextSuffix(String val) {
        Matcher matcher = Pattern.compile("(Sample)([0-9]+)$").matcher(val);
        if (matcher.matches()) {
            int num = Integer.parseInt(matcher.group(2));
            return String.valueOf(matcher.group(1)) + (num + 1);
        }
        return String.valueOf(val) + "1";
    }

    public IStatus removeAllEntities() {
        IFile descriptorFile = this.getDescriptorFile();
        if (descriptorFile == null || !descriptorFile.exists()) {
            return Status.OK_STATUS;
        }
        String tagName = "entity";
        LiferayDescriptorHelper.DOMModelEditOperation editOperation = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

            protected IStatus doExecute(IDOMDocument document) {
                return ServiceBuilderDescriptorHelper.this.removeAllElements(document, "entity");
            }
        };
        return editOperation.execute();
    }
}

