/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.job;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.portlet.core.PortletCore;
import com.liferay.ide.project.core.IProjectBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class BuildLanguageJob
extends Job {
    protected IFile langFile;

    public BuildLanguageJob(IFile langFile) {
        super(Msgs.buildLanguages);
        this.langFile = langFile;
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus retval;
        block11: {
            retval = null;
            IWorkspaceDescription desc = ResourcesPlugin.getWorkspace().getDescription();
            boolean saveAutoBuild = desc.isAutoBuilding();
            desc.setAutoBuilding(false);
            monitor.beginTask(Msgs.buildingLanguages, 100);
            IWorkspaceRunnable workspaceRunner = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BuildLanguageJob.this.runBuildLang(monitor);
                }
            };
            try {
                try {
                    ResourcesPlugin.getWorkspace().setDescription(desc);
                    ResourcesPlugin.getWorkspace().run(workspaceRunner, monitor);
                }
                catch (CoreException e1) {
                    retval = PortletCore.createErrorStatus((Exception)((Object)e1));
                    desc = ResourcesPlugin.getWorkspace().getDescription();
                    desc.setAutoBuilding(saveAutoBuild);
                    try {
                        ResourcesPlugin.getWorkspace().setDescription(desc);
                    }
                    catch (CoreException e12) {
                        retval = PortletCore.createErrorStatus((Exception)((Object)e12));
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                desc = ResourcesPlugin.getWorkspace().getDescription();
                desc.setAutoBuilding(saveAutoBuild);
                try {
                    ResourcesPlugin.getWorkspace().setDescription(desc);
                }
                catch (CoreException e1) {
                    retval = PortletCore.createErrorStatus((Exception)((Object)e1));
                }
                throw throwable;
            }
            desc = ResourcesPlugin.getWorkspace().getDescription();
            desc.setAutoBuilding(saveAutoBuild);
            try {
                ResourcesPlugin.getWorkspace().setDescription(desc);
            }
            catch (CoreException e1) {
                retval = PortletCore.createErrorStatus((Exception)((Object)e1));
            }
        }
        return retval == null || retval.isOK() ? Status.OK_STATUS : retval;
    }

    protected void runBuildLang(IProgressMonitor monitor) throws CoreException {
        ILiferayProject liferayProject = LiferayCore.create((Object)this.getProject());
        if (liferayProject == null) {
            throw new CoreException(PortletCore.createErrorStatus(NLS.bind((String)Msgs.couldNotCreateLiferayProject, (Object)this.getProject())));
        }
        IProjectBuilder builder = (IProjectBuilder)liferayProject.adapt(IProjectBuilder.class);
        if (builder == null) {
            throw new CoreException(PortletCore.createErrorStatus(NLS.bind((String)Msgs.couldNotCreateProjectBuilder, (Object)this.getProject())));
        }
        monitor.worked(50);
        IStatus retval = builder.buildLang(this.langFile, monitor);
        if (retval == null) {
            retval = PortletCore.createErrorStatus(NLS.bind((String)Msgs.errorRunningBuildLang, (Object)this.getProject()));
        }
        try {
            this.getProject().refreshLocal(2, monitor);
        }
        catch (Exception e) {
            PortletCore.logError(e);
        }
        this.getProject().build(10, monitor);
        try {
            this.getProject().refreshLocal(2, monitor);
        }
        catch (Exception e) {
            PortletCore.logError(e);
        }
        if (retval == null || !retval.isOK()) {
            throw new CoreException(retval);
        }
        monitor.worked(90);
    }

    private IProject getProject() {
        return this.langFile.getProject();
    }

    private static class Msgs
    extends NLS {
        public static String buildingLanguages;
        public static String buildLanguages;
        public static String couldNotCreateProjectBuilder;
        public static String couldNotCreateLiferayProject;
        public static String errorRunningBuildLang;

        static {
            Msgs.initializeMessages((String)BuildLanguageJob.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

