/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.operation;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.portlet.core.PortletCore;
import com.liferay.ide.portlet.core.dd.LiferayDisplayDescriptorHelper;
import com.liferay.ide.portlet.core.dd.PortletDescriptorHelper;
import com.liferay.ide.portlet.core.operation.INewPortletClassDataModelProperties;
import com.liferay.ide.portlet.core.operation.PortletSupertypesValidator;
import com.liferay.ide.project.core.IPluginWizardFragmentProperties;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.core.util.SearchFilesVisitor;
import com.liferay.ide.server.util.ServerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.internal.common.operations.JavaModelUtil;
import org.eclipse.jst.j2ee.internal.web.operations.NewWebClassDataModelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Version;
import org.osgi.service.prefs.Preferences;

public class NewPortletClassDataModelProvider
extends NewWebClassDataModelProvider
implements INewPortletClassDataModelProperties,
IPluginWizardFragmentProperties {
    private static final String PORTLET_SUFFIX_PATTERN = "([Pp][Oo][Rr][Tt][Ll][Ee][Tt])$";
    protected Properties categories;
    protected Properties entryCategories;
    protected boolean fragment;
    protected IProject initialProject;

    public NewPortletClassDataModelProvider() {
    }

    public NewPortletClassDataModelProvider(boolean fragment) {
        this.fragment = fragment;
    }

    public NewPortletClassDataModelProvider(boolean fragment, IProject initialProject) {
        this(fragment);
        this.initialProject = initialProject;
    }

    protected ParamValue[] createDefaultParamValuesForModes(String[] modes, String[] names, String[] values) {
        Assert.isTrue((modes != null && names != null && values != null && modes.length == names.length && names.length == values.length ? 1 : 0) != 0);
        ArrayList<ParamValue> defaultParams = new ArrayList<ParamValue>();
        String prependPath = this.getDataModel().getStringProperty("INewPortletClassDataModelProperties.CREATE_JSPS_FOLDER");
        int i = 0;
        while (i < modes.length) {
            if (this.getBooleanProperty(modes[i])) {
                ParamValue paramValue = CommonFactory.eINSTANCE.createParamValue();
                paramValue.setName(names[i]);
                if (CoreUtil.isNullOrEmpty((String)prependPath)) {
                    paramValue.setValue(values[i]);
                } else {
                    if (CoreUtil.isNullOrEmpty((String)prependPath) || !prependPath.startsWith("/")) {
                        prependPath = "/" + prependPath;
                    }
                    paramValue.setValue(String.valueOf(prependPath) + values[i]);
                }
                defaultParams.add(paramValue);
            }
            ++i;
        }
        return defaultParams.toArray(new ParamValue[0]);
    }

    protected Properties getCategories() {
        if (this.categories == null) {
            ILiferayPortal portal;
            ILiferayProject liferayProject = LiferayCore.create((Object)this.getProject());
            if (liferayProject == null) {
                try {
                    liferayProject = LiferayCore.create((Object)this.getRuntime());
                }
                catch (CoreException e) {
                    PortletCore.logError((Exception)((Object)e));
                }
            }
            if ((portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class)) != null) {
                IProject[] workspaceProjects;
                this.categories = portal.getPortletCategories();
                IProject[] iProjectArray = workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = workspaceProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    LiferayDisplayDescriptorHelper liferayDisplayDH;
                    String[] portletCategories;
                    IProject workspaceProject = iProjectArray[n2];
                    if (ProjectUtil.isPortletProject((IProject)workspaceProject) && (portletCategories = (liferayDisplayDH = new LiferayDisplayDescriptorHelper(workspaceProject)).getAllPortletCategories()).length > 0) {
                        String[] stringArray = portletCategories;
                        int n3 = portletCategories.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String portletCategory = stringArray[n4];
                            if (this.findExistingCategory(portletCategory) == null) {
                                this.categories.put(portletCategory, portletCategory);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        return this.categories;
    }

    public Object getDefaultProperty(String propertyName) {
        if ("NewJavaClassDataModel.SUPERCLASS".equals(propertyName)) {
            return "com.liferay.util.bridges.mvc.MVCPortlet";
        }
        if ("NewJavaClassDataModel.CONSTRUCTOR".equals(propertyName)) {
            return false;
        }
        if ("INewPortletClassDataModelProperties.INIT_OVERRIDE".equals(propertyName) || "INewPortletClassDataModelProperties.DOVIEW_OVERRIDE".equals(propertyName)) {
            return true;
        }
        if ("INewPortletClassDataModelProperties.DESTROY_OVERRIDE".equals(propertyName)) {
            return false;
        }
        if ("NewJavaClassDataModel.JAVA_PACKAGE".equals(propertyName)) {
            return "com.test";
        }
        if ("NewJavaClassDataModel.CLASS_NAME".equals(propertyName)) {
            return "NewPortlet";
        }
        if ("INewPortletClassDataModelProperties.PORTLET_NAME".equals(propertyName) || "INewPortletClassDataModelProperties.LIFERAY_PORTLET_NAME".equals(propertyName)) {
            return this.getPortletNameFromClassName(this.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
        }
        if ("INewPortletClassDataModelProperties.DISPLAY_NAME".equals(propertyName) || "INewPortletClassDataModelProperties.TITLE".equals(propertyName) || "INewPortletClassDataModelProperties.SHORT_TITLE".equals(propertyName)) {
            return this.getDisplayNameFromPortletName(this.getStringProperty("INewPortletClassDataModelProperties.PORTLET_NAME"));
        }
        if ("INewPortletClassDataModelProperties.KEYWORDS".equals(propertyName)) {
            return "";
        }
        if ("INewPortletClassDataModelProperties.INIT_PARAMS".equals(propertyName)) {
            return this.getInitParams();
        }
        if ("INewPortletClassDataModelProperties.VIEW_MODE".equals(propertyName)) {
            return true;
        }
        if ("INewPortletClassDataModelProperties.CREATE_JSPS".equals(propertyName)) {
            return true;
        }
        if ("INewPortletClassDataModelProperties.CREATE_JSPS_FOLDER".equals(propertyName)) {
            if (this.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_NEW_PORTLET_CLASS")) {
                return "/html/" + this.getProperty("NewJavaClassDataModel.CLASS_NAME").toString().toLowerCase().replaceAll(PORTLET_SUFFIX_PATTERN, "");
            }
            return "/html/" + this.getProperty("INewPortletClassDataModelProperties.PORTLET_NAME").toString().toLowerCase().replaceAll(PORTLET_SUFFIX_PATTERN, "");
        }
        if ("INewPortletClassDataModelProperties.ICON_FILE".equals(propertyName)) {
            return "/icon.png";
        }
        if ("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE".equals(propertyName)) {
            return false;
        }
        if ("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE_PATH".equals(propertyName)) {
            return "content/Language.properties";
        }
        if ("INewPortletClassDataModelProperties.ALLOW_MULTIPLE".equals(propertyName)) {
            return false;
        }
        if ("INewPortletClassDataModelProperties.CSS_FILE".equals(propertyName)) {
            return "/css/main.css";
        }
        if ("INewPortletClassDataModelProperties.JAVASCRIPT_FILE".equals(propertyName)) {
            return "/js/main.js";
        }
        if ("INewPortletClassDataModelProperties.CSS_CLASS_WRAPPER".equals(propertyName)) {
            return String.valueOf(this.getProperty("INewPortletClassDataModelProperties.PORTLET_NAME").toString().toLowerCase()) + "-portlet";
        }
        if ("INewPortletClassDataModelProperties.ID".equals(propertyName)) {
            return this.getProperty("INewPortletClassDataModelProperties.PORTLET_NAME");
        }
        if ("INewPortletClassDataModelProperties.CATEGORY".equals(propertyName)) {
            return "category.sample";
        }
        if ("INewPortletClassDataModelProperties.ENTRY_CATEGORY".equals(propertyName)) {
            return "category.my";
        }
        if ("INewPortletClassDataModelProperties.ENTRY_WEIGHT".equals(propertyName)) {
            return "1.5";
        }
        if ("INewPortletClassDataModelProperties.ENTRY_CLASS_NAME".equals(propertyName)) {
            return String.valueOf(this.getStringProperty("NewJavaClassDataModel.CLASS_NAME")) + "ControlPanelEntry";
        }
        if ("INewPortletClassDataModelProperties.SHOW_NEW_CLASS_OPTION".equals(propertyName)) {
            return true;
        }
        if ("INewPortletClassDataModelProperties.CREATE_NEW_PORTLET_CLASS".equals(propertyName)) {
            return true;
        }
        if ("INewPortletClassDataModelProperties.USE_DEFAULT_PORTLET_CLASS".equals(propertyName)) {
            return false;
        }
        if ("NewJavaClassDataModel.QUALIFIED_CLASS_NAME".equals(propertyName)) {
            if (this.getBooleanProperty("INewPortletClassDataModelProperties.USE_DEFAULT_PORTLET_CLASS")) {
                return "com.liferay.util.bridges.mvc.MVCPortlet";
            }
        } else {
            if ("IArtifactEditOperationDataModelProperties.PROJECT_NAME".equals(propertyName) && this.initialProject != null) {
                return this.initialProject.getName();
            }
            if ("INewPortletClassDataModelProperties.INIT_PARAMETER_NAME".equals(propertyName)) {
                String version;
                String initParameterName = "template";
                ILiferayProject liferayProject = LiferayCore.create((Object)this.getProject());
                ILiferayPortal portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class);
                if (portal != null && (version = portal.getVersion()) != null) {
                    Version portalVersion = Version.parseVersion((String)version);
                    if (CoreUtil.compareVersions((Version)portalVersion, (Version)ILiferayConstants.V610) < 0) {
                        initParameterName = "jsp";
                    }
                    return initParameterName;
                }
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object getDisplayNameFromPortletName(String oldName) {
        String[] words = oldName.split("\\s|-|_");
        StringBuilder newName = new StringBuilder();
        int i = 0;
        while (i < words.length) {
            if (!words[i].isEmpty()) {
                if (words[i].length() > 1) {
                    String word = String.valueOf(words[i].substring(0, 1).toUpperCase()) + words[i].substring(1, words[i].length());
                    newName.append(word);
                    newName.append(" ");
                } else if (words[i].length() == 1) {
                    newName.append(words[i].substring(0, 1).toUpperCase());
                    newName.append(" ");
                }
            }
            ++i;
        }
        return newName.toString().trim();
    }

    protected Properties getEntryCategories() {
        ILiferayPortal portal;
        ILiferayProject liferayProject = LiferayCore.create((Object)this.getProject());
        if (liferayProject == null) {
            try {
                liferayProject = LiferayCore.create((Object)this.getRuntime());
            }
            catch (CoreException e) {
                PortletCore.logError((Exception)((Object)e));
            }
        }
        if ((portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class)) != null) {
            return portal.getPortletEntryCategories();
        }
        return null;
    }

    protected Object getInitParams() {
        ArrayList initParams = new ArrayList();
        if (this.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_JSPS")) {
            String[] modes = ALL_PORTLET_MODES;
            ParamValue[] paramVals = null;
            try {
                ILiferayProject liferayProject = LiferayCore.create((Object)this.getProject());
                ILiferayPortal portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class);
                String version = portal.getVersion();
                Version portalVersion = Version.parseVersion((String)version);
                if (CoreUtil.compareVersions((Version)portalVersion, (Version)ILiferayConstants.V610) >= 0) {
                    paramVals = this.createDefaultParamValuesForModes(modes, initNames61, initValues);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (paramVals == null) {
                paramVals = this.createDefaultParamValuesForModes(modes, initNames60, initValues);
            }
            Collections.addAll(initParams, paramVals);
        }
        return initParams;
    }

    protected String getPortletNameFromClassName(String oldName) {
        String SPLIT_PATTERN = "(?<!^)(?=[A-Z][^A-Z])|(?<=[^A-Z])(?=[A-Z])";
        String[] words = oldName.replaceAll(PORTLET_SUFFIX_PATTERN, "").split("(?<!^)(?=[A-Z][^A-Z])|(?<=[^A-Z])(?=[A-Z])");
        StringBuilder newName = new StringBuilder();
        int i = 0;
        while (i < words.length) {
            if (i > 0) {
                newName.append("-");
            }
            newName.append(words[i]);
            ++i;
        }
        return newName.toString().toLowerCase();
    }

    protected IProject getProject() {
        IProject project = (IProject)this.getProperty("NewJavaClassDataModel.PROJECT");
        if (CoreUtil.isLiferayProject((IProject)project)) {
            return project;
        }
        return null;
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if ("INewPortletClassDataModelProperties.VIEW_MODE".equals(propertyName)) {
            return new DataModelPropertyDescriptor(this.getProperty(propertyName), "view");
        }
        if ("INewPortletClassDataModelProperties.EDIT_MODE".equals(propertyName)) {
            return new DataModelPropertyDescriptor(this.getProperty(propertyName), "edit");
        }
        if ("INewPortletClassDataModelProperties.HELP_MODE".equals(propertyName)) {
            return new DataModelPropertyDescriptor(this.getProperty(propertyName), "help");
        }
        if ("INewPortletClassDataModelProperties.ABOUT_MODE".equals(propertyName)) {
            return new DataModelPropertyDescriptor(this.getProperty(propertyName), "about");
        }
        if ("INewPortletClassDataModelProperties.CONFIG_MODE".equals(propertyName)) {
            return new DataModelPropertyDescriptor(this.getProperty(propertyName), "config");
        }
        if ("INewPortletClassDataModelProperties.EDITDEFAULTS_MODE".equals(propertyName)) {
            return new DataModelPropertyDescriptor(this.getProperty(propertyName), "edit_defaults");
        }
        if ("INewPortletClassDataModelProperties.EDITGUEST_MODE".equals(propertyName)) {
            return new DataModelPropertyDescriptor(this.getProperty(propertyName), "edit_guest");
        }
        if ("INewPortletClassDataModelProperties.PREVIEW_MODE".equals(propertyName)) {
            return new DataModelPropertyDescriptor(this.getProperty(propertyName), "preview");
        }
        if ("INewPortletClassDataModelProperties.PRINT_MODE".equals(propertyName)) {
            return new DataModelPropertyDescriptor(this.getProperty(propertyName), "print");
        }
        if ("INewPortletClassDataModelProperties.CATEGORY".equals(propertyName)) {
            if (this.getProperty("INewPortletClassDataModelProperties.CATEGORY").equals("category.sample")) {
                return new DataModelPropertyDescriptor((Object)"category.sample", "Sample");
            }
        } else if ("INewPortletClassDataModelProperties.ENTRY_CATEGORY".equals(propertyName)) {
            Version portalVersion;
            ILiferayPortal portal;
            Object entryCategory = this.getProperty("INewPortletClassDataModelProperties.ENTRY_CATEGORY");
            if (entryCategory != null && this.getEntryCategories() != null && this.getEntryCategories().get(entryCategory) != null) {
                return new DataModelPropertyDescriptor(entryCategory, this.getEntryCategories().get(entryCategory).toString());
            }
            ILiferayProject liferayProject = LiferayCore.create((Object)this.getProject());
            if (liferayProject == null) {
                try {
                    liferayProject = LiferayCore.create((Object)this.getRuntime());
                }
                catch (CoreException e) {
                    PortletCore.logError((Exception)((Object)e));
                }
            }
            if ((portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class)) != null && CoreUtil.compareVersions((Version)(portalVersion = Version.parseVersion((String)portal.getVersion())), (Version)ILiferayConstants.V620) < 0) {
                return new DataModelPropertyDescriptor((Object)"category.my", "My Account Section");
            }
            return new DataModelPropertyDescriptor((Object)"category.my", "My Account Administration");
        }
        return super.getPropertyDescriptor(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("INewPortletClassDataModelProperties.TEMPLATE_STORE");
        propertyNames.add("INewPortletClassDataModelProperties.CONTEXT_TYPE");
        propertyNames.add("INewPortletClassDataModelProperties.INIT_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.DESTROY_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.DOVIEW_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.DOEDIT_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.DOHELP_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.DOABOUT_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.DOCONFIG_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.DOEDITDEFAULTS_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.DOEDITGUEST_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.DOPREVIEW_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.DOPRINT_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.PROCESSACTION_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.SERVERESOURCE_OVERRIDE");
        propertyNames.add("INewPortletClassDataModelProperties.PORTLET_NAME");
        propertyNames.add("INewPortletClassDataModelProperties.DISPLAY_NAME");
        propertyNames.add("INewPortletClassDataModelProperties.TITLE");
        propertyNames.add("INewPortletClassDataModelProperties.SHORT_TITLE");
        propertyNames.add("INewPortletClassDataModelProperties.KEYWORDS");
        propertyNames.add("INewPortletClassDataModelProperties.INIT_PARAMETER_NAME");
        propertyNames.add("INewPortletClassDataModelProperties.INIT_PARAMS");
        propertyNames.add("INewPortletClassDataModelProperties.VIEW_MODE");
        propertyNames.add("INewPortletClassDataModelProperties.EDIT_MODE");
        propertyNames.add("INewPortletClassDataModelProperties.HELP_MODE");
        propertyNames.add("INewPortletClassDataModelProperties.ABOUT_MODE");
        propertyNames.add("INewPortletClassDataModelProperties.CONFIG_MODE");
        propertyNames.add("INewPortletClassDataModelProperties.EDITDEFAULTS_MODE");
        propertyNames.add("INewPortletClassDataModelProperties.EDITGUEST_MODE");
        propertyNames.add("INewPortletClassDataModelProperties.PREVIEW_MODE");
        propertyNames.add("INewPortletClassDataModelProperties.PRINT_MODE");
        propertyNames.add("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE");
        propertyNames.add("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE_PATH");
        propertyNames.add("INewPortletClassDataModelProperties.CREATE_JSPS");
        propertyNames.add("INewPortletClassDataModelProperties.CREATE_JSPS_FOLDER");
        propertyNames.add("INewPortletClassDataModelProperties.LIFERAY_PORTLET_NAME");
        propertyNames.add("INewPortletClassDataModelProperties.ICON_FILE");
        propertyNames.add("INewPortletClassDataModelProperties.ALLOW_MULTIPLE");
        propertyNames.add("INewPortletClassDataModelProperties.CSS_FILE");
        propertyNames.add("INewPortletClassDataModelProperties.JAVASCRIPT_FILE");
        propertyNames.add("INewPortletClassDataModelProperties.CSS_CLASS_WRAPPER");
        propertyNames.add("INewPortletClassDataModelProperties.ID");
        propertyNames.add("INewPortletClassDataModelProperties.CATEGORY");
        propertyNames.add("INewPortletClassDataModelProperties.ADD_TO_CONTROL_PANEL");
        propertyNames.add("INewPortletClassDataModelProperties.ENTRY_CATEGORY");
        propertyNames.add("INewPortletClassDataModelProperties.ENTRY_WEIGHT");
        propertyNames.add("INewPortletClassDataModelProperties.CREATE_ENTRY_CLASS");
        propertyNames.add("INewPortletClassDataModelProperties.ENTRY_CLASS_NAME");
        propertyNames.add("IPluginWizardFragmentProperties.FACET_RUNTIME");
        propertyNames.add("IPluginWizardFragmentProperties.REMOVE_EXISTING_ARTIFACTS");
        propertyNames.add("INewPortletClassDataModelProperties.SHOW_NEW_CLASS_OPTION");
        propertyNames.add("INewPortletClassDataModelProperties.CREATE_NEW_PORTLET_CLASS");
        propertyNames.add("INewPortletClassDataModelProperties.USE_DEFAULT_PORTLET_CLASS");
        return propertyNames;
    }

    protected IRuntime getRuntime() throws CoreException {
        IRuntime runtime = null;
        if (this.fragment) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime bRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)this.getDataModel().getProperty("IPluginWizardFragmentProperties.FACET_RUNTIME");
            runtime = ServerUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)bRuntime);
        } else {
            runtime = ServerUtil.getRuntime((IProject)this.getProject());
        }
        return runtime;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        Properties entryCategories;
        if ("NewJavaClassDataModel.SUPERCLASS".equals(propertyName)) {
            String defaults = "com.liferay.util.bridges.mvc.MVCPortlet,com.liferay.portal.kernel.portlet.LiferayPortlet,javax.portlet.GenericPortlet";
            Object[] defaultVals = defaults.split(",");
            try {
                IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
                Preferences preferences = PortletCore.getPreferences();
                String superclasses = preferences.get("portlet-superclasses-used", null);
                if (superclasses != null) {
                    String[] customVals = superclasses.split(",");
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.addAll(Arrays.asList(defaultVals));
                    IType portletType = JavaModelUtil.findType((IJavaProject)javaProject, (String)"javax.portlet.Portlet");
                    IJavaSearchScope scope = BasicSearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)portletType, (boolean)true, (boolean)true, null);
                    int i = 0;
                    while (i < customVals.length) {
                        IType type = JavaModelUtil.findType((IJavaProject)javaProject, (String)customVals[i]);
                        if (type != null && scope.encloses((IJavaElement)type)) {
                            list.add(customVals[i]);
                        }
                        ++i;
                    }
                    return DataModelPropertyDescriptor.createDescriptors((Object[])list.toArray(), (String[])list.toArray(new String[0]));
                }
            }
            catch (JavaModelException javaProject) {
                // empty catch block
            }
            return DataModelPropertyDescriptor.createDescriptors((Object[])defaultVals, (String[])defaultVals);
        }
        if ("INewPortletClassDataModelProperties.CATEGORY".equals(propertyName)) {
            Properties categories = this.getCategories();
            if (categories != null && categories.size() > 0) {
                return DataModelPropertyDescriptor.createDescriptors((Object[])categories.keySet().toArray(new Object[0]), (String[])categories.values().toArray(new String[0]));
            }
        } else if ("INewPortletClassDataModelProperties.ENTRY_CATEGORY".equals(propertyName) && (entryCategories = this.getEntryCategories()) != null && entryCategories.size() > 0) {
            Object[] keys = entryCategories.keySet().toArray();
            Arrays.sort(keys);
            String[] values = new String[keys.length];
            int i = 0;
            while (i < keys.length) {
                values[i] = entryCategories.getProperty(keys[i].toString());
                ++i;
            }
            return DataModelPropertyDescriptor.createDescriptors((Object[])keys, (String[])values);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    protected IFile getWorkspaceFile(IPath file) {
        IFile retval = null;
        try {
            retval = ResourcesPlugin.getWorkspace().getRoot().getFile(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    private String findExistingCategory(String portletCategory) {
        Enumeration<Object> keys = this.categories.keys();
        String trimmedCategory = portletCategory.trim();
        String retval = null;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = this.categories.get(key);
            if (!trimmedCategory.equals(key) && !trimmedCategory.equals(value)) continue;
            retval = key.toString();
            break;
        }
        return retval;
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("INewPortletClassDataModelProperties.VIEW_MODE".equals(propertyName)) {
            return false;
        }
        if ("INewPortletClassDataModelProperties.INIT_OVERRIDE".equals(propertyName)) {
            return false;
        }
        if ("INewPortletClassDataModelProperties.ABOUT_MODE".equals(propertyName) || "INewPortletClassDataModelProperties.CONFIG_MODE".equals(propertyName) || "INewPortletClassDataModelProperties.EDITDEFAULTS_MODE".equals(propertyName) || "INewPortletClassDataModelProperties.EDITGUEST_MODE".equals(propertyName) || "INewPortletClassDataModelProperties.PREVIEW_MODE".equals(propertyName) || "INewPortletClassDataModelProperties.PRINT_MODE".equals(propertyName)) {
            if (this.fragment) {
                return true;
            }
            if (this.getProject() == null) {
                return false;
            }
            return PortletSupertypesValidator.isLiferayPortletSuperclass(this.getDataModel(), true);
        }
        if ("NewJavaClassDataModel.CLASS_NAME".equals(propertyName) || "NewJavaClassDataModel.JAVA_PACKAGE".equals(propertyName) || "NewJavaClassDataModel.SUPERCLASS".equals(propertyName)) {
            return this.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_NEW_PORTLET_CLASS");
        }
        if ("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE_PATH".equals(propertyName)) {
            return this.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE");
        }
        if ("INewPortletClassDataModelProperties.CREATE_JSPS_FOLDER".equals(propertyName)) {
            return this.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_JSPS");
        }
        return super.isPropertyEnabled(propertyName);
    }

    public boolean isValidPortletClass(String qualifiedClassName) {
        try {
            IType portletType;
            IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
            if (javaProject != null && (portletType = JavaModelUtil.findType((IJavaProject)javaProject, (String)"javax.portlet.Portlet")) != null) {
                IJavaSearchScope scope = BasicSearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)portletType, (boolean)true, (boolean)true, null);
                IType classType = JavaModelUtil.findType((IJavaProject)javaProject, (String)qualifiedClassName);
                if (classType != null && scope.encloses((IJavaElement)classType)) {
                    return true;
                }
            }
        }
        catch (JavaModelException e) {
            PortletCore.logError((Exception)((Object)e));
        }
        return false;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("INewPortletClassDataModelProperties.VIEW_MODE".equals(propertyName)) {
            this.setProperty("INewPortletClassDataModelProperties.DOVIEW_OVERRIDE", propertyValue);
        } else if ("INewPortletClassDataModelProperties.EDIT_MODE".equals(propertyName)) {
            this.setProperty("INewPortletClassDataModelProperties.DOEDIT_OVERRIDE", propertyValue);
        } else if ("INewPortletClassDataModelProperties.HELP_MODE".equals(propertyName)) {
            this.setProperty("INewPortletClassDataModelProperties.DOHELP_OVERRIDE", propertyValue);
        } else if ("INewPortletClassDataModelProperties.ABOUT_MODE".equals(propertyName) && PortletSupertypesValidator.isLiferayPortletSuperclass(this.getDataModel())) {
            this.setProperty("INewPortletClassDataModelProperties.DOABOUT_OVERRIDE", propertyValue);
        } else if ("INewPortletClassDataModelProperties.CONFIG_MODE".equals(propertyName)) {
            this.setProperty("INewPortletClassDataModelProperties.DOCONFIG_OVERRIDE", propertyValue);
        } else if ("INewPortletClassDataModelProperties.EDITDEFAULTS_MODE".equals(propertyName)) {
            this.setProperty("INewPortletClassDataModelProperties.DOEDITDEFAULTS_OVERRIDE", propertyValue);
        } else if ("INewPortletClassDataModelProperties.EDITGUEST_MODE".equals(propertyName)) {
            this.setProperty("INewPortletClassDataModelProperties.DOEDITGUEST_OVERRIDE", propertyValue);
        } else if ("INewPortletClassDataModelProperties.PREVIEW_MODE".equals(propertyName)) {
            this.setProperty("INewPortletClassDataModelProperties.DOPREVIEW_OVERRIDE", propertyValue);
        } else if ("INewPortletClassDataModelProperties.PRINT_MODE".equals(propertyName)) {
            this.setProperty("INewPortletClassDataModelProperties.DOPRINT_OVERRIDE", propertyValue);
        } else if ("NewJavaClassDataModel.SUPERCLASS".equals(propertyName)) {
            this.getDataModel().notifyPropertyChange("INewPortletClassDataModelProperties.VIEW_MODE", 3);
            this.getDataModel().notifyPropertyChange("INewPortletClassDataModelProperties.EDIT_MODE", 3);
            this.getDataModel().notifyPropertyChange("INewPortletClassDataModelProperties.HELP_MODE", 3);
            this.getDataModel().notifyPropertyChange("INewPortletClassDataModelProperties.ABOUT_MODE", 3);
            this.getDataModel().notifyPropertyChange("INewPortletClassDataModelProperties.CONFIG_MODE", 3);
            this.getDataModel().notifyPropertyChange("INewPortletClassDataModelProperties.EDITDEFAULTS_MODE", 3);
            this.getDataModel().notifyPropertyChange("INewPortletClassDataModelProperties.EDITGUEST_MODE", 3);
            this.getDataModel().notifyPropertyChange("INewPortletClassDataModelProperties.PREVIEW_MODE", 3);
            this.getDataModel().notifyPropertyChange("INewPortletClassDataModelProperties.PRINT_MODE", 3);
        } else if ("INewPortletClassDataModelProperties.PORTLET_NAME".equals(propertyName)) {
            String portletName = this.getStringProperty(propertyName);
            this.getDataModel().setStringProperty("INewPortletClassDataModelProperties.LIFERAY_PORTLET_NAME", portletName);
        } else if ("INewPortletClassDataModelProperties.LIFERAY_PORTLET_NAME".equals(propertyName)) {
            String liferayPortletName = this.getStringProperty(propertyName);
            this.getDataModel().setStringProperty("INewPortletClassDataModelProperties.PORTLET_NAME", liferayPortletName);
        } else if ("INewPortletClassDataModelProperties.CATEGORY".equals(propertyName)) {
            String portletCategory = this.findExistingCategory(propertyValue.toString());
            if (portletCategory != null) {
                this.getDataModel().setProperty("INewPortletClassDataModelProperties.CATEGORY", (Object)portletCategory);
            }
            return true;
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String propertyName) {
        if ("INewPortletClassDataModelProperties.PORTLET_NAME".equals(propertyName)) {
            String[] portletNames;
            String portletName = this.getStringProperty("INewPortletClassDataModelProperties.PORTLET_NAME");
            if (portletName == null || portletName.length() == 0) {
                return PortletCore.createErrorStatus(Msgs.portletNameEmpty);
            }
            PortletDescriptorHelper portletDescriptorHelper = new PortletDescriptorHelper(this.getTargetProject());
            String[] stringArray = portletNames = portletDescriptorHelper.getAllPortletNames();
            int n = portletNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equals(portletName)) {
                    return PortletCore.createErrorStatus(Msgs.portletNameExists);
                }
                ++n2;
            }
        } else {
            if ("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE_PATH".equals(propertyName)) {
                if (!this.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE")) {
                    return Status.OK_STATUS;
                }
                boolean validPath = false;
                boolean validFileName = false;
                String val = this.getStringProperty(propertyName);
                if (CoreUtil.isNullOrEmpty((String)val)) {
                    return PortletCore.createErrorStatus(Msgs.resourceBundleFilePathValid);
                }
                try {
                    Path path = new Path(val);
                    validPath = path.isValidPath(val);
                    if ("properties".equals(path.getFileExtension())) {
                        validFileName = true;
                    }
                }
                catch (Exception path) {
                    // empty catch block
                }
                if (!validPath) {
                    return PortletCore.createErrorStatus(Msgs.resourceBundleFilePathValid);
                }
                if (validFileName) {
                    return super.validate(propertyName);
                }
                return PortletCore.createWarningStatus(Msgs.resourceBundleFilePathEndWithProperties);
            }
            if ("INewPortletClassDataModelProperties.CREATE_JSPS_FOLDER".equals(propertyName)) {
                IWebProject webproject;
                if (!this.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_JSPS")) {
                    return Status.OK_STATUS;
                }
                String folderValue = this.getStringProperty(propertyName);
                if (CoreUtil.isNullOrEmpty((String)folderValue)) {
                    return PortletCore.createErrorStatus(Msgs.jspFolderNotEmpty);
                }
                IProject targetProject = this.getTargetProject();
                if (!CoreUtil.isNullOrEmpty((String)folderValue) && targetProject != null && (webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)targetProject)) != null) {
                    IFolder defaultDocroot = webproject.getDefaultDocrootFolder();
                    IStatus validation = this.validateFolder(defaultDocroot, folderValue);
                    if (validation != null && !validation.isOK()) {
                        return validation;
                    }
                    String path = new Path(folderValue).segment(0);
                    if (!CoreUtil.isNullOrEmpty((String)path) && path.equals(this.getStringProperty("INewPortletClassDataModelProperties.PORTLET_NAME"))) {
                        return PortletCore.createErrorStatus(Msgs.jspFolderNotMatchPortletName);
                    }
                }
            } else {
                if ("NewJavaClassDataModel.SOURCE_FOLDER".equals(propertyName) && this.fragment) {
                    return Status.OK_STATUS;
                }
                if ("NewJavaClassDataModel.SUPERCLASS".equals(propertyName)) {
                    String superclass = this.getStringProperty(propertyName);
                    if (CoreUtil.isNullOrEmpty((String)superclass)) {
                        return PortletCore.createErrorStatus(Msgs.specifyPortletSuperclass);
                    }
                    if (this.fragment) {
                        return JavaConventions.validateJavaTypeName((String)superclass, (String)"1.5", (String)"1.5");
                    }
                    if (!this.isValidPortletClass(superclass)) {
                        return PortletCore.createErrorStatus(Msgs.portletSuperclassValid);
                    }
                } else if ("INewPortletClassDataModelProperties.CATEGORY".equals(propertyName)) {
                    String category = this.getStringProperty(propertyName);
                    if (category.matches("\\s*")) {
                        return PortletCore.createErrorStatus(Msgs.categoryNameEmpty);
                    }
                } else {
                    if ("INewPortletClassDataModelProperties.ENTRY_WEIGHT".equals(propertyName)) {
                        if (!this.getBooleanProperty("INewPortletClassDataModelProperties.ADD_TO_CONTROL_PANEL")) {
                            return Status.OK_STATUS;
                        }
                        String entryweight = this.getStringProperty(propertyName);
                        if (!CoreUtil.isNumeric((String)entryweight)) {
                            return PortletCore.createErrorStatus(Msgs.specifyValidDouble);
                        }
                        return Status.OK_STATUS;
                    }
                    if ("INewPortletClassDataModelProperties.ENTRY_CLASS_NAME".equals(propertyName)) {
                        IStatus existsStatus;
                        if (!this.getBooleanProperty("INewPortletClassDataModelProperties.ADD_TO_CONTROL_PANEL") || !this.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_ENTRY_CLASS")) {
                            return Status.OK_STATUS;
                        }
                        String entryclasswrapper = this.getStringProperty(propertyName);
                        if (this.validateJavaClassName(entryclasswrapper).getSeverity() != 4 && (existsStatus = this.canCreateTypeInClasspath(entryclasswrapper)).matches(6)) {
                            return existsStatus;
                        }
                        return this.validateJavaClassName(entryclasswrapper);
                    }
                    if ("NewJavaClassDataModel.CLASS_NAME".equals(propertyName) && this.getBooleanProperty("INewPortletClassDataModelProperties.USE_DEFAULT_PORTLET_CLASS")) {
                        return Status.OK_STATUS;
                    }
                }
            }
        }
        return super.validate(propertyName);
    }

    private IStatus validateFolder(IFolder folder, String folderValue) {
        List viewJspFiles;
        if (folder == null || folderValue == null) {
            return null;
        }
        if (!Path.ROOT.isValidPath(folderValue)) {
            return LiferayCore.createErrorStatus((String)Msgs.folderValueInvalid);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(folder.getFolder(folderValue).getFullPath().toString(), 2);
        if (!result.isOK()) {
            return LiferayCore.createErrorStatus((String)Msgs.folderValueInvalid);
        }
        if (folder.getFolder((IPath)new Path(folderValue)).exists() && (viewJspFiles = new SearchFilesVisitor().searchFiles((IResource)folder, "view.jsp")) != null && viewJspFiles.size() > 0) {
            return LiferayCore.createWarningStatus((String)Msgs.viewJspAlreadyExists);
        }
        return null;
    }

    private static class Msgs
    extends NLS {
        public static String categoryNameEmpty;
        public static String folderValueInvalid;
        public static String jspFolderNotEmpty;
        public static String jspFolderNotMatchPortletName;
        public static String portletNameEmpty;
        public static String portletNameExists;
        public static String portletSuperclassValid;
        public static String resourceBundleFilePathEndWithProperties;
        public static String resourceBundleFilePathValid;
        public static String specifyPortletSuperclass;
        public static String specifyValidDouble;
        public static String viewJspAlreadyExists;

        static {
            Msgs.initializeMessages((String)NewPortletClassDataModelProvider.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

