/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ProjectUI
extends AbstractUIPlugin {
    public static final String PROPERTIES_IMAGE_ID = "properties";
    public static final String WAR_IMAGE_ID = "war.image";
    public static final String CHECKED_IMAGE_ID = "checked.image";
    public static final String MIGRATION_TASKS_IMAGE_ID = "migration.tasks.image";
    public static final String UNCHECKED_IMAGE_ID = "unchecked.image";
    public static final String MODULE_DEPENDENCY_IAMGE_ID = "module.dependency.image";
    public static final String LAST_SDK_IMPORT_LOCATION_PREF = "last.sdk.import.location";
    private static ProjectUI plugin;
    public static final String PLUGIN_ID = "com.liferay.ide.project.ui";

    public static IStatus createErrorStatus(String msg) {
        return ProjectUI.createErrorStatus(msg, null);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, msg, (Throwable)e);
    }

    public static IStatus createInfoStatus(String msg) {
        return new Status(1, PLUGIN_ID, msg, null);
    }

    public static ProjectUI getDefault() {
        return plugin;
    }

    public Image getImage(String imageName) {
        Image image = ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("icons/e16/" + imageName)).createImage();
        return image;
    }

    public static void logError(Exception e) {
        ProjectUI.getDefault().getLog().log(ProjectUI.createErrorStatus(e.getMessage(), e));
    }

    public static void logError(String msg, Exception e) {
        ProjectUI.getDefault().getLog().log(ProjectUI.createErrorStatus(msg, e));
    }

    public static void logInfo(String msg) {
        ProjectUI.getDefault().getLog().log(ProjectUI.createInfoStatus(msg));
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        Path checked = new Path("icons/e16/checked.png");
        URL checkedurl = FileLocator.find((Bundle)bundle, (IPath)checked, null);
        ImageDescriptor checkeddesc = ImageDescriptor.createFromURL((URL)checkedurl);
        registry.put(CHECKED_IMAGE_ID, checkeddesc);
        Path unchecked = new Path("icons/e16/unchecked.png");
        URL uncheckedurl = FileLocator.find((Bundle)bundle, (IPath)unchecked, null);
        ImageDescriptor uncheckeddesc = ImageDescriptor.createFromURL((URL)uncheckedurl);
        registry.put(UNCHECKED_IMAGE_ID, uncheckeddesc);
        Path migrationtasks = new Path("icons/e16/migration-tasks.png");
        URL migrationtasksurl = FileLocator.find((Bundle)bundle, (IPath)migrationtasks, null);
        ImageDescriptor migrationtasksdesc = ImageDescriptor.createFromURL((URL)migrationtasksurl);
        registry.put(MIGRATION_TASKS_IMAGE_ID, migrationtasksdesc);
        registry.put(WAR_IMAGE_ID, ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/e16/war.gif"), null)));
        registry.put(PROPERTIES_IMAGE_ID, ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/e16/properties.png"), null)));
        registry.put(MODULE_DEPENDENCY_IAMGE_ID, ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/e16/new_module_dependency.png"), null)));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }
}

