/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.jdt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class ComponentPropertyCompletionProposal
extends JavaCompletionProposal {
    private int replacementStart;
    private int replacementEnd;
    private String addtionalString;
    private String source;
    private boolean fIsValidated = true;
    private boolean fReplacementOffsetComputed;
    private boolean fReplacementLengthComputed;

    public ComponentPropertyCompletionProposal(JavaContentAssistInvocationContext jdt, String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance, int replacementStart, int replacementEnd, String addtionalString, String source) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance);
        this.replacementStart = replacementStart;
        this.replacementEnd = replacementEnd;
        this.addtionalString = addtionalString;
        this.source = source;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, true);
            }
        };
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        String info = this.addtionalString;
        return info;
    }

    protected boolean isOffsetValid(int offset) {
        return this.getReplacementOffset() <= offset;
    }

    public final int getReplacementOffset() {
        if (!this.fReplacementOffsetComputed) {
            this.setReplacementOffset(this.getReplaceStart());
        }
        return super.getReplacementOffset();
    }

    public void setReplacementLength(int replacementLength) {
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        super.setReplacementLength(replacementLength);
    }

    public int getReplaceStart() {
        if (this.source.contains("\"")) {
            return this.replacementStart - 1;
        }
        return this.replacementStart;
    }

    public int getReplaceEnd() {
        return this.replacementEnd;
    }

    public int setReplaceEnd(int replacementEnd) {
        this.replacementEnd = replacementEnd;
        return this.replacementEnd;
    }

    public final int getReplacementLength() {
        if (!this.fReplacementLengthComputed) {
            this.setReplacementLength(this.getReplaceEnd() - this.getReplaceStart());
        }
        if (this.source.contains("\"") && this.source.endsWith("\"")) {
            return super.getReplacementLength() + 1;
        }
        return super.getReplacementLength();
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (!this.isOffsetValid(offset)) {
            this.fIsValidated = false;
            return false;
        }
        String prefix = this.getPrefix(document, offset);
        String removeQuotPrefix = prefix.replace("\"", "");
        this.fIsValidated = this.isValidPrefix(removeQuotPrefix);
        if (this.fIsValidated) {
            this.setReplaceEnd(this.getReplaceEnd());
        }
        if (this.fIsValidated && event != null) {
            int delta = (event.fText == null ? 0 : event.fText.length()) - event.fLength;
            int newLength = Math.max(this.getReplacementLength() + delta, 0);
            this.setReplacementLength(newLength);
            this.setReplaceEnd(this.getReplaceEnd() + delta);
        }
        return this.fIsValidated;
    }

    protected boolean isValidPrefix(String prefix) {
        String word = TextProcessor.deprocess((String)this.getDisplayString());
        return this.isPrefix(prefix, word);
    }
}

