/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.AutoMigrateException;
import com.liferay.blade.api.AutoMigrator;
import com.liferay.blade.api.Problem;
import com.liferay.ide.project.core.upgrade.FileProblems;
import com.liferay.ide.project.core.upgrade.UpgradeProblems;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.migration.AutoCorrectAction;
import com.liferay.ide.project.ui.migration.MigrationUtil;
import com.liferay.ide.project.ui.migration.ProblemsContainer;
import com.liferay.ide.project.ui.migration.RunMigrationToolAction;
import com.liferay.ide.ui.util.UIUtil;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IViewPart;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class AutoCorrectAllAction
extends Action {
    List<ProblemsContainer> _problemsContainerList;

    public AutoCorrectAllAction(List<ProblemsContainer> problemsContainerList) {
        this._problemsContainerList = problemsContainerList;
    }

    public void run() {
        final BundleContext context = FrameworkUtil.getBundle(AutoCorrectAction.class).getBundleContext();
        WorkspaceJob job = new WorkspaceJob("Auto correcting all of migration problem."){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus retval = Status.OK_STATUS;
                try {
                    if (AutoCorrectAllAction.this._problemsContainerList != null && AutoCorrectAllAction.this._problemsContainerList.size() > 0) {
                        for (ProblemsContainer problemsContainer : AutoCorrectAllAction.this._problemsContainerList) {
                            UpgradeProblems[] upgradeProblemsArray = problemsContainer.getProblemsArray();
                            int n = upgradeProblemsArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                FileProblems[] FileProblemsArray;
                                UpgradeProblems upgradeProblems = upgradeProblemsArray[n2];
                                FileProblems[] fileProblemsArray = FileProblemsArray = upgradeProblems.getProblems();
                                int n3 = FileProblemsArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    FileProblems fileProblems = fileProblemsArray[n4];
                                    List problems = fileProblems.getProblems();
                                    for (Problem problem : problems) {
                                        if (problem.autoCorrectContext == null) continue;
                                        String autoCorrectKey = null;
                                        int filterKeyIndex = problem.autoCorrectContext.indexOf(":");
                                        autoCorrectKey = filterKeyIndex > -1 ? problem.autoCorrectContext.substring(0, filterKeyIndex) : problem.autoCorrectContext;
                                        Collection refs = context.getServiceReferences(AutoMigrator.class, "(auto.correct=" + autoCorrectKey + ")");
                                        IResource file = MigrationUtil.getIResourceFromProblem(problem);
                                        for (ServiceReference ref : refs) {
                                            IMarker problemMarker;
                                            AutoMigrator autoMigrator = (AutoMigrator)context.getService(ref);
                                            int problemsCorrected = autoMigrator.correctProblems(problem.file, problems);
                                            if (problemsCorrected <= 0 || file == null || (problemMarker = file.findMarker(problem.markerId)) == null || !problemMarker.exists()) continue;
                                            problemMarker.delete();
                                        }
                                        file.refreshLocal(1, monitor);
                                    }
                                    ++n4;
                                }
                                ++n2;
                            }
                        }
                    }
                    UIUtil.sync((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            IViewPart view = UIUtil.findView((String)"com.liferay.ide.project.ui.upgradeView");
                            new RunMigrationToolAction("Run Migration Tool", view.getViewSite().getShell()).run();
                        }
                    });
                }
                catch (InvalidSyntaxException problemsContainer) {
                }
                catch (AutoMigrateException | CoreException e) {
                    retval = ProjectUI.createErrorStatus("Unable to auto correct problem", (Exception)e);
                    return retval;
                }
                return retval;
            }
        };
        job.schedule();
    }
}

