/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class CUCache {
    private static final Map<File, WeakReference<CompilationUnit>> _map = new WeakHashMap<File, WeakReference<CompilationUnit>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompilationUnit getCU(File file, char[] javaSource) {
        Map<File, WeakReference<CompilationUnit>> map = _map;
        synchronized (map) {
            WeakReference<CompilationUnit> astRef = _map.get(file);
            if (astRef == null || astRef.get() == null) {
                CompilationUnit newAst = CUCache.createCompilationUnit(file.getName(), javaSource);
                _map.put(file, new WeakReference<CompilationUnit>(newAst));
                return newAst;
            }
            return (CompilationUnit)astRef.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unget(File file) {
        Map<File, WeakReference<CompilationUnit>> map = _map;
        synchronized (map) {
            _map.remove(file);
        }
    }

    private static CompilationUnit createCompilationUnit(String unitName, char[] javaSource) {
        ASTParser parser = ASTParser.newParser((int)2);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.6", (Map)options);
        parser.setCompilerOptions((Map)options);
        parser.setUnitName(unitName);
        String[] sources = new String[]{""};
        String[] classpath = new String[]{""};
        parser.setEnvironment(classpath, sources, new String[]{"UTF-8"}, true);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setSource(javaSource);
        parser.setIgnoreMethodBodies(false);
        return (CompilationUnit)parser.createAST(null);
    }
}

