/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.MarkerUtil;
import com.liferay.ide.project.core.upgrade.MigrationProblems;
import com.liferay.ide.project.ui.migration.MigrationUtil;
import com.liferay.ide.project.ui.upgrade.animated.FindBreakingChangesPage;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.project.ui.upgrade.animated.UpgradeView;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.actions.SelectionProviderAction;

public class RemoveAction
extends SelectionProviderAction
implements IAction {
    public RemoveAction(ISelectionProvider provider) {
        super(provider, "Remove");
    }

    public void run() {
        FindBreakingChangesPage page = UpgradeView.getPage(Page.FINDBREACKINGCHANGES_PAGE_ID, FindBreakingChangesPage.class);
        TreeViewer treeViewer = page.getTreeViewer();
        Object selection = treeViewer.getStructuredSelection().getFirstElement();
        if (selection instanceof MigrationProblems) {
            MigrationProblems migrationProblem = (MigrationProblems)selection;
            MigrationUtil.removeMigrationProblems(migrationProblem);
            IResource project = MigrationUtil.getResourceFromMigrationProblems(migrationProblem);
            if (project != null) {
                MarkerUtil.clearMarkers((IResource)project, (String)"com.liferay.ide.project.core.MigrationProblemMarker", null);
            }
        }
        treeViewer.setInput((Object)CoreUtil.getWorkspaceRoot());
        treeViewer.expandToLevel(2);
    }

    public void selectionChanged(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof MigrationProblems) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }
}

