/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.modules;

import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.modules.NewLiferayComponentOp;
import com.liferay.ide.project.ui.ProjectUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewLiferayComponentWizard
extends SapphireWizard<NewLiferayComponentOp>
implements IWorkbenchWizard,
INewWizard {
    private boolean firstErrorMessageRemoved = false;
    private IProject initialProject;
    private IPackageFragment initialPackage;
    private IPackageFragmentRoot initialPackageRoot;

    public NewLiferayComponentWizard() {
        super((Element)NewLiferayComponentWizard.createDefaultOp(), DefinitionLoader.sdef(NewLiferayComponentWizard.class).wizard());
    }

    public IWizardPage[] getPages() {
        IWizardPage[] wizardPages = super.getPages();
        if (!this.firstErrorMessageRemoved && wizardPages != null) {
            SapphireWizardPage wizardPage = (SapphireWizardPage)wizardPages[0];
            String message = wizardPage.getMessage();
            int messageType = wizardPage.getMessageType();
            if (messageType == 3 && !CoreUtil.isNullOrEmpty((String)message)) {
                wizardPage.setMessage("Please enter a project name.", 0);
                this.firstErrorMessageRemoved = true;
            }
        }
        return wizardPages;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            IBundleProject bundleProject;
            Object element = selection.getFirstElement();
            if (element instanceof IResource) {
                this.initialProject = ((IResource)element).getProject();
            } else if (element instanceof IJavaProject) {
                this.initialProject = ((IJavaProject)element).getProject();
            } else if (element instanceof IPackageFragment) {
                this.initialPackage = (IPackageFragment)element;
                this.initialProject = ((IJavaElement)element).getResource().getProject();
            } else if (element instanceof IPackageFragmentRoot) {
                this.initialPackageRoot = (IPackageFragmentRoot)element;
                this.initialProject = this.initialPackageRoot.getJavaProject().getProject();
            } else if (element instanceof IJavaElement) {
                this.initialProject = ((IJavaElement)element).getResource().getProject();
            }
            if (this.initialProject != null && (bundleProject = (IBundleProject)LiferayCore.create(IBundleProject.class, (Object)this.initialProject)) != null && "jar".equals(bundleProject.getBundleShape()) && !bundleProject.isFragmentBundle()) {
                ((NewLiferayComponentOp)this.element()).setProjectName(this.initialProject.getName());
                if (this.initialPackage != null) {
                    ((NewLiferayComponentOp)this.element()).setPackageName(this.initialPackage.getElementName());
                }
            }
        }
    }

    private static NewLiferayComponentOp createDefaultOp() {
        return (NewLiferayComponentOp)NewLiferayComponentOp.TYPE.instantiate();
    }

    public void performPostFinish() {
        NewLiferayComponentOp op = (NewLiferayComponentOp)((NewLiferayComponentOp)this.element()).nearest(NewLiferayComponentOp.class);
        IProject currentProject = CoreUtil.getProject((String)((String)op.getProjectName().content()));
        if (currentProject == null) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)currentProject);
        if (javaProject == null) {
            return;
        }
        try {
            String componentClass = (String)op.getComponentClassName().content();
            String packageName = op.getPackageName().text();
            IType type = javaProject.findType(packageName, componentClass);
            if (type == null) {
                return;
            }
            final IFile classFile = (IFile)type.getResource();
            if (classFile != null) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IFile)classFile, (boolean)true);
                        }
                        catch (Exception e) {
                            ProjectUI.logError(e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
    }
}

