/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.action;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.ui.dialog.CustomProjectSelectionDialog;
import com.liferay.ide.project.ui.upgrade.action.BaseActionHandler;
import com.liferay.ide.project.ui.upgrade.action.CompileAction;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;

public class BuildServiceActionHandler
extends BaseActionHandler {
    private void deleteLegacyFiles(IProject project, IProgressMonitor monitor) throws CoreException {
        String relativePath = "/docroot/WEB-INF/src/META-INF";
        IFile portletSpringXML = project.getFile(String.valueOf(relativePath) + "/portlet-spring.xml");
        IFile shardDataSourceSpringXML = project.getFile(String.valueOf(relativePath) + "/shard-data-source-spring.xml");
        if (portletSpringXML.exists()) {
            portletSpringXML.delete(true, monitor);
        }
        if (shardDataSourceSpringXML.exists()) {
            shardDataSourceSpringXML.delete(true, monitor);
        }
    }

    private List<IProject> getServiceBuilderProjects() {
        IProject[] projects;
        ArrayList<IProject> results = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = CoreUtil.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IFile serviceFile = project.getFile("/docroot/WEB-INF/service.xml");
            if (serviceFile.exists()) {
                results.add(project);
            }
            ++n2;
        }
        return results;
    }

    protected Object run(Presentation context) {
        Object[] selectedProjects;
        List<IProject> projects = this.getServiceBuilderProjects();
        CustomProjectSelectionDialog dialog = new CustomProjectSelectionDialog(UIUtil.getActiveShell());
        dialog.setProjects(projects);
        final ArrayList<IProject> liferayServiceProjects = new ArrayList<IProject>();
        if (dialog.open() == 0 && (selectedProjects = dialog.getResult()) != null) {
            Object[] objectArray = selectedProjects;
            int n = selectedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object project = objectArray[n2];
                if (project instanceof IJavaProject) {
                    IJavaProject p = (IJavaProject)project;
                    liferayServiceProjects.add(p.getProject());
                }
                ++n2;
            }
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        for (IProject project : liferayServiceProjects) {
                            ProcessConsole pc;
                            BuildServiceActionHandler.this.deleteLegacyFiles(project, monitor);
                            SDK sdk = SDKUtil.getSDK((IProject)project);
                            sdk.runCommand(project, project.getFile("build.xml"), "build-service", null, monitor);
                            project.refreshLocal(2, monitor);
                            IConsole console = CompileAction.getConsole("build-service");
                            if (console == null || !(pc = (ProcessConsole)console).getDocument().get().contains("BUILD FAILED")) continue;
                            return;
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

