/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.dialog.JavaProjectSelectionDialog;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.ui.util.SWTUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class BuildPage
extends Page {
    private TableViewer tableViewer;
    private Image imageProject;
    private Image imageSuccess;
    private Image imageFail;
    private TableViewElement[] tableViewElements;

    public BuildPage(Composite parent, int style, LiferayUpgradeDataModel dataModel) {
        super(parent, style, dataModel, BUILD_PAGE_ID, true);
        Composite container = new Composite((Composite)this, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = new TableViewer(container);
        this.tableViewer.setContentProvider((IContentProvider)new TableViewContentProvider());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                TableViewElement tableViewElement = (TableViewElement)selection.getFirstElement();
                final String projectName = tableViewElement.projectName;
                final IProject project = ProjectUtil.getProject((String)projectName);
                Boolean openNewLiferayProjectWizard = MessageDialog.openQuestion((Shell)UIUtil.getActiveShell(), (String)"Build Project", (String)"Do you want to build this project again?");
                if (openNewLiferayProjectWizard.booleanValue()) {
                    WorkspaceJob workspaceJob = new WorkspaceJob("Build Project......"){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            monitor.beginTask("Start to build project......", 100);
                            monitor.setTaskName("Build " + projectName + " Project...");
                            monitor.worked(100);
                            if (monitor.isCanceled()) {
                                return StatusBridge.create((Status)Status.createOkStatus());
                            }
                            boolean buildFlag = BuildPage.this.getBuildStatus(monitor, project);
                            int i = 0;
                            while (i < BuildPage.this.tableViewElements.length) {
                                if (((BuildPage)(this).BuildPage.this).tableViewElements[i].projectName == projectName) {
                                    ((BuildPage)(this).BuildPage.this).tableViewElements[i].buildStatus = buildFlag ? "Build Successful" : "Build Failed";
                                }
                                ++i;
                            }
                            UIUtil.async((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    BuildPage.this.tableViewer.setInput((Object)BuildPage.this.tableViewElements);
                                    BuildPage.this.tableViewer.refresh();
                                }
                            });
                            return StatusBridge.create((Status)Status.createOkStatus());
                        }
                    };
                    workspaceJob.setUser(true);
                    workspaceJob.schedule();
                }
            }
        });
        TableViewerColumn colFirstName = new TableViewerColumn(this.tableViewer, 0);
        colFirstName.getColumn().setWidth(400);
        colFirstName.getColumn().setText("projectName");
        colFirstName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return BuildPage.this.imageProject;
            }

            public String getText(Object element) {
                TableViewElement tableViewElement = (TableViewElement)element;
                return tableViewElement.projectName;
            }
        });
        TableViewerColumn colSecondName = new TableViewerColumn(this.tableViewer, 0);
        colSecondName.getColumn().setWidth(200);
        colSecondName.getColumn().setText("Build Status");
        colSecondName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                TableViewElement tableViewElement = (TableViewElement)element;
                if (tableViewElement.buildStatus.equals("Build Successful")) {
                    return BuildPage.this.imageSuccess;
                }
                if (tableViewElement.buildStatus.equals("Build Failed")) {
                    return BuildPage.this.imageFail;
                }
                return null;
            }

            public String getText(Object element) {
                TableViewElement tableViewElement = (TableViewElement)element;
                return tableViewElement.buildStatus;
            }
        });
        Table table = this.tableViewer.getTable();
        GridData tableData = new GridData(4, 4, true, true, 1, 1);
        table.setLayoutData((Object)tableData);
        table.setLinesVisible(false);
        Button buildButton = new Button(container, 8);
        buildButton.setText("Build...");
        buildButton.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        buildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPage.this.buildProjects();
            }
        });
    }

    private void buildProjects() {
        List<IProject> selectProjectList = this.getSelectedProjects();
        final IProject[] selectProjects = selectProjectList.toArray(new IProject[selectProjectList.size()]);
        this.createImages();
        try {
            WorkspaceJob workspaceJob = new WorkspaceJob("Build Project......"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    String projectName;
                    final ArrayList<TableViewElement> tableViewElementList = new ArrayList<TableViewElement>();
                    int count = selectProjects.length;
                    if (count <= 0) {
                        return StatusBridge.create((Status)Status.createOkStatus());
                    }
                    int unit = 100 / count;
                    monitor.beginTask("Start to build project......", 100);
                    int i = 0;
                    while (i < count) {
                        IProject project = selectProjects[i];
                        projectName = project.getName();
                        TableViewElement tableViewElement = new TableViewElement(projectName, "Not Build");
                        tableViewElementList.add(tableViewElement);
                        ++i;
                    }
                    UIUtil.async((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BuildPage.this.tableViewElements = tableViewElementList.toArray(new TableViewElement[tableViewElementList.size()]);
                            BuildPage.this.tableViewer.setInput((Object)BuildPage.this.tableViewElements);
                            BuildPage.this.tableViewer.refresh();
                        }
                    });
                    i = 0;
                    while (i < count) {
                        monitor.worked(i + 1 * unit);
                        if (monitor.isCanceled()) break;
                        if (i == count - 1) {
                            monitor.worked(100);
                        }
                        TableViewElement viewElement = (TableViewElement)tableViewElementList.get(i);
                        projectName = viewElement.projectName;
                        IProject project = ProjectUtil.getProject((String)projectName);
                        monitor.setTaskName("Build " + projectName + " Project...");
                        boolean buildFlag = BuildPage.this.getBuildStatus(monitor, project);
                        viewElement.buildStatus = buildFlag ? "Build Successful" : "Build Failed";
                        UIUtil.async((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                BuildPage.this.tableViewElements = tableViewElementList.toArray(new TableViewElement[tableViewElementList.size()]);
                                BuildPage.this.tableViewer.setInput((Object)BuildPage.this.tableViewElements);
                                BuildPage.this.tableViewer.refresh();
                            }
                        });
                        ++i;
                    }
                    return StatusBridge.create((Status)Status.createOkStatus());
                }
            };
            workspaceJob.setUser(true);
            workspaceJob.schedule();
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
    }

    private void createImages() {
        this.imageProject = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        if (this.imageProject.isDisposed()) {
            this.imageProject = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT").createImage();
        }
        URL greenTickUrl = ProjectUI.getDefault().getBundle().getEntry("/images/yes_badge.png");
        this.imageSuccess = ImageDescriptor.createFromURL((URL)greenTickUrl).createImage();
        this.imageSuccess.getImageData().scaledTo(16, 16);
        this.imageFail = JFaceResources.getImage((String)"dialog_message_error_image");
    }

    private boolean getBuildStatus(IProgressMonitor monitor, IProject project) throws CoreException {
        IBundleProject bundleProject = (IBundleProject)LiferayCore.create(IBundleProject.class, (Object)project);
        IPath outputBundlepath = null;
        try {
            outputBundlepath = bundleProject.getOutputBundle(true, monitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (outputBundlepath != null && !outputBundlepath.isEmpty()) {
            project.refreshLocal(2, monitor);
            return true;
        }
        return false;
    }

    private List<IProject> getSelectedProjects() {
        Object[] selectedProjects;
        ArrayList<IProject> projects = new ArrayList<IProject>();
        JavaProjectSelectionDialog dialog = new JavaProjectSelectionDialog(Display.getCurrent().getActiveShell());
        if (dialog.open() == 0 && (selectedProjects = dialog.getResult()) != null) {
            Object[] objectArray = selectedProjects;
            int n = selectedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object project = objectArray[n2];
                if (project instanceof IJavaProject) {
                    IJavaProject p = (IJavaProject)project;
                    projects.add(p.getProject());
                }
                ++n2;
            }
        }
        return projects;
    }

    @Override
    public void createSpecialDescriptor(Composite parent, int style) {
        String descriptor = "This step will help you to build all your projects.\nYou can rebuild the project by double-clicking it.";
        String url = "";
        Link link = SWTUtil.createHyperLink((Composite)this, (int)style, (String)"This step will help you to build all your projects.\nYou can rebuild the project by double-clicking it.", (int)1, (String)url);
        link.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
    }

    @Override
    public String getPageTitle() {
        return "Build";
    }

    class TableViewContentProvider
    implements IStructuredContentProvider {
        TableViewContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TableViewElement[]) {
                return (TableViewElement[])inputElement;
            }
            return new Object[]{inputElement};
        }
    }

    class TableViewElement {
        public String projectName;
        public String buildStatus;

        public TableViewElement(String projectName, String buildStatus) {
            this.projectName = projectName;
            this.buildStatus = buildStatus;
        }
    }
}

