/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.blade.api.Problem;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.upgrade.FileProblems;
import com.liferay.ide.project.core.upgrade.UpgradeAssistantSettingsUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.migration.AutoCorrectAction;
import com.liferay.ide.project.ui.migration.AutoCorrectAllAction;
import com.liferay.ide.project.ui.migration.IgnoreAction;
import com.liferay.ide.project.ui.migration.IgnoreAlwaysAction;
import com.liferay.ide.project.ui.migration.MarkDoneAction;
import com.liferay.ide.project.ui.migration.MarkUndoneAction;
import com.liferay.ide.project.ui.migration.MigrationContentProvider;
import com.liferay.ide.project.ui.migration.MigrationLabelProvider;
import com.liferay.ide.project.ui.migration.MigrationProblemsContainer;
import com.liferay.ide.project.ui.migration.MigrationUtil;
import com.liferay.ide.project.ui.migration.MigratorComparator;
import com.liferay.ide.project.ui.migration.ProblemsContainer;
import com.liferay.ide.project.ui.migration.RemoveAction;
import com.liferay.ide.project.ui.migration.RunMigrationToolAction;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.ui.util.SWTUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class FindBreakingChangesPage
extends Page
implements IDoubleClickListener {
    public static final String ID = "com.liferay.ide.project.ui.findBreakingChangesPage";
    private static final Image IMAGE_CHECKED = ProjectUI.getDefault().getImageRegistry().get("checked.image");
    private static final Image IMAGE_UNCHECKED = ProjectUI.getDefault().getImageRegistry().get("unchecked.image");
    public static boolean showAll = false;
    private boolean isBrowserMaximized = false;
    MigrationContentProvider migrationContentProvider;
    private SashForm _sashForm;
    private Browser _browser;
    private TableViewer _problemsViewer;
    private MigratorComparator _comparator;
    private TreeViewer _treeViewer;

    public FindBreakingChangesPage(final Composite parent, int style, LiferayUpgradeDataModel dataModel) {
        super(parent, style, dataModel, FINDBREACKINGCHANGES_PAGE_ID, true);
        Composite findBreakingchangesContainer = SWTUtil.createComposite((Composite)this, (int)2, (int)1, (int)1808, (int)0, (int)0);
        this._sashForm = new SashForm(findBreakingchangesContainer, 256);
        this._sashForm.setLayoutData((Object)new GridData(1808));
        SashForm nestedSashForm = new SashForm((Composite)this._sashForm, 768);
        nestedSashForm.setLayoutData((Object)new GridData(1808));
        GridData treeData = new GridData(1808);
        treeData.minimumWidth = 200;
        treeData.heightHint = 200;
        this._treeViewer = new TreeViewer((Composite)nestedSashForm);
        this._treeViewer.getTree().setLayoutData((Object)treeData);
        this.migrationContentProvider = new MigrationContentProvider();
        this._treeViewer.setContentProvider((IContentProvider)this.migrationContentProvider);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this._treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new MigrationLabelProvider(), decorator));
        this._treeViewer.setInput(this.getInitialInput());
        MenuManager menuMgr = new MenuManager();
        RemoveAction removeAction = new RemoveAction((ISelectionProvider)this._treeViewer);
        menuMgr.add((IAction)removeAction);
        Menu menu = menuMgr.createContextMenu((Control)this._treeViewer.getTree());
        this._treeViewer.getTree().setMenu(menu);
        this._treeViewer.expandAll();
        this.createTableView((Composite)nestedSashForm);
        this._browser = new Browser((Composite)this._sashForm, 2048);
        this._browser.setLayoutData((Object)new GridData(1808));
        this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List<Problem> problems = null;
                problems = showAll ? MigrationUtil.getProblemsFromTreeNode(event.getSelection()) : MigrationUtil.getCurrentProblemsFromTreeNode(event.getSelection());
                if (problems != null && problems.size() > 0) {
                    FindBreakingChangesPage.this._problemsViewer.setInput((Object)problems.toArray());
                    FindBreakingChangesPage.this._problemsViewer.setSelection((ISelection)new StructuredSelection((Object)problems.get(0)));
                } else {
                    FindBreakingChangesPage.this._problemsViewer.setInput(null);
                }
            }
        });
        this._problemsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(final SelectionChangedEvent event) {
                UIUtil.async((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FindBreakingChangesPage.this.updateForm(event);
                    }
                }, (long)50L);
            }
        });
        this._treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof ITreeSelection) {
                    ITreeSelection treeSelection = (ITreeSelection)selection;
                    Object selectedItem = treeSelection.getFirstElement();
                    if (selectedItem instanceof FileProblems) {
                        MigrationUtil.openEditor((FileProblems)selectedItem);
                        return;
                    }
                    TreePath[] paths = treeSelection.getPathsFor(selectedItem);
                    int i = 0;
                    while (i < paths.length) {
                        FindBreakingChangesPage.this._treeViewer.setExpandedState((Object)paths[i], !FindBreakingChangesPage.this._treeViewer.getExpandedState((Object)paths[i]));
                        ++i;
                    }
                }
            }
        });
        Composite buttonContainer = new Composite(findBreakingchangesContainer, 0);
        GridLayout buttonContainerLayout = new GridLayout(1, false);
        buttonContainerLayout.marginHeight = 0;
        buttonContainerLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonContainerLayout);
        buttonContainer.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        Button findbreakingchangesButton = new Button(buttonContainer, 0);
        findbreakingchangesButton.setImage(this.getImage("migration-tasks.png"));
        findbreakingchangesButton.setToolTipText("Find Breaking Changes");
        findbreakingchangesButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IViewPart view = UIUtil.findView((String)"com.liferay.ide.project.ui.upgradeView");
                new RunMigrationToolAction("Run Migration Tool", view.getViewSite().getShell()).run();
            }
        });
        Button correctAllImportIssuesButton = new Button(buttonContainer, 0);
        correctAllImportIssuesButton.setImage(this.getImage("bandaid.gif"));
        correctAllImportIssuesButton.setToolTipText("Automatically Correct Problems");
        correctAllImportIssuesButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                new AutoCorrectAllAction(FindBreakingChangesPage.this.getInitialInput()).run();
            }
        });
        Button expendAll = new Button(buttonContainer, 0);
        expendAll.setImage(this.getImage("expandall.gif"));
        expendAll.setToolTipText("Expand All");
        expendAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FindBreakingChangesPage.this._treeViewer.expandAll();
            }
        });
        Button collapseAll = new Button(buttonContainer, 0);
        Image collapseAllImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_COLLAPSEALL");
        collapseAll.setImage(collapseAllImage);
        collapseAll.setToolTipText("Collapse All");
        collapseAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FindBreakingChangesPage.this._treeViewer.collapseAll();
            }
        });
        Button openIgnoredList = new Button(buttonContainer, 0);
        openIgnoredList.setImage(this.getImage("properties.png"));
        openIgnoredList.setToolTipText("Open Ignored List");
        openIgnoredList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"com.liferay.ide.project.ui.migrationProblemPreferencePage", null, null);
                dialog.open();
            }
        });
        Button hideTree = new Button(buttonContainer, 2);
        hideTree.setImage(this.getImage("hide_tree.png"));
        hideTree.setToolTipText("Hide Tree");
        hideTree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FindBreakingChangesPage.this.isBrowserMaximized = !FindBreakingChangesPage.this.isBrowserMaximized;
                FindBreakingChangesPage.this._sashForm.setMaximizedControl(FindBreakingChangesPage.this.isBrowserMaximized ? FindBreakingChangesPage.this._browser : null);
            }
        });
        this._sashForm.setWeights(new int[]{2, 3});
    }

    private void createColumns(final TableViewer _problemsViewer) {
        String[] titles = new String[]{"Resolved", "Line", "Problem"};
        int[] bounds = new int[]{65, 55, 200};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0], _problemsViewer);
        col.setEditingSupport(new EditingSupport((ColumnViewer)_problemsViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)_problemsViewer.getTable());
            }

            protected Object getValue(Object element) {
                if (((Problem)element).getStatus() == 1) {
                    return true;
                }
                return false;
            }

            protected void setValue(Object element, Object value) {
                if (value == Boolean.TRUE) {
                    new MarkDoneAction().run((Problem)element, (ISelectionProvider)_problemsViewer);
                } else {
                    new MarkUndoneAction().run((Problem)element, (ISelectionProvider)_problemsViewer);
                }
            }
        });
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                Problem p = (Problem)element;
                if (p.getStatus() == 1) {
                    return IMAGE_CHECKED;
                }
                return IMAGE_UNCHECKED;
            }

            public String getText(Object element) {
                return null;
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1], _problemsViewer);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Problem p = (Problem)element;
                return p.lineNumber > -1 ? String.valueOf(p.lineNumber) : "";
            }
        });
        col = this.createTableViewerColumn(titles[2], bounds[2], _problemsViewer);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Problem p = (Problem)element;
                return p.title;
            }

            public void update(ViewerCell cell) {
                super.update(cell);
                Table table = _problemsViewer.getTable();
                table.getColumn(2).pack();
            }
        });
    }

    public void createTableView(Composite container) {
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 200;
        gridData.minimumHeight = 200;
        this._problemsViewer = new TableViewer(container, 68354);
        this._problemsViewer.getTable().setLayoutData((Object)gridData);
        this.createColumns(this._problemsViewer);
        Table table = this._problemsViewer.getTable();
        table.setHeaderVisible(true);
        this._problemsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._problemsViewer.setComparer(null);
        this._comparator = new MigratorComparator();
        this._problemsViewer.setComparator((ViewerComparator)this._comparator);
        MenuManager menuMgr = new MenuManager();
        MarkDoneAction markDoneAction = new MarkDoneAction((ISelectionProvider)this._problemsViewer);
        MarkUndoneAction markUndoneAction = new MarkUndoneAction((ISelectionProvider)this._problemsViewer);
        IgnoreAction ignoreAction = new IgnoreAction((ISelectionProvider)this._problemsViewer);
        IgnoreAlwaysAction ignoreAlways = new IgnoreAlwaysAction((ISelectionProvider)this._problemsViewer);
        AutoCorrectAction autoCorrectAction = new AutoCorrectAction((ISelectionProvider)this._problemsViewer);
        menuMgr.add((IAction)markDoneAction);
        menuMgr.add((IAction)markUndoneAction);
        menuMgr.add((IAction)ignoreAction);
        menuMgr.add((IAction)autoCorrectAction);
        menuMgr.add((IAction)ignoreAlways);
        Menu menu = menuMgr.createContextMenu((Control)table);
        table.setMenu(menu);
        this._problemsViewer.addDoubleClickListener((IDoubleClickListener)this);
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, TableViewer viewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, viewer.getTable().indexOf(column)));
        return viewerColumn;
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)event.getSelection();
            Object element = ss.getFirstElement();
            if (element instanceof Problem) {
                MigrationUtil.openEditor((Problem)element);
            } else if (element instanceof FileProblems) {
                MigrationUtil.openEditor((FileProblems)element);
            }
        }
    }

    private String generateFormText(Problem problem) {
        StringBuilder sb = new StringBuilder();
        sb.append("<form><p>");
        sb.append("<b>Problem:</b> " + problem.title + "<br/><br/>");
        sb.append("<b>Description:</b><br/>");
        sb.append("\t" + problem.summary + "<br/><br/>");
        if (problem.getAutoCorrectContext() != null && problem.autoCorrectContext.length() > 0) {
            sb.append("<a href='autoCorrect'>Correct this problem automatically</a><br/><br/>");
        }
        if (problem.html != null && problem.html.length() > 0) {
            sb.append("<a href='html'>See documentation for how to correct this problem.</a><br/><br/>");
        }
        if (problem.ticket != null && problem.ticket.length() > 0) {
            sb.append("<b>Tickets:</b> " + this.getLinkTags(problem.ticket) + "<br/><br/>");
        }
        sb.append("</p></form>");
        return sb.toString();
    }

    private Image getImage(String imageName) {
        return ProjectUI.getDefault().getImage(imageName);
    }

    public TableViewer getProblemsViewer() {
        return this._problemsViewer;
    }

    public List<ProblemsContainer> getInitialInput() {
        ArrayList<ProblemsContainer> _problems = null;
        try {
            MigrationProblemsContainer container = (MigrationProblemsContainer)UpgradeAssistantSettingsUtil.getObjectFromStore(MigrationProblemsContainer.class);
            if (container != null) {
                _problems = new ArrayList<ProblemsContainer>();
                _problems.add(container);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.migrationContentProvider.setProblems(_problems);
        return _problems;
    }

    private String getLinkTags(String ticketNumbers) {
        String[] ticketNumberArray = ticketNumbers.split(",");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < ticketNumberArray.length) {
            String ticketNumber = ticketNumberArray[i];
            sb.append("<a href='https://issues.liferay.com/browse/");
            sb.append(ticketNumber);
            sb.append("'>");
            sb.append(ticketNumber);
            sb.append("</a>");
            if (ticketNumberArray.length > 1 && i != ticketNumberArray.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindBreakingChangesPage.this._comparator.setColumn(index);
                int dir = FindBreakingChangesPage.this._comparator.getDirection();
                FindBreakingChangesPage.this._problemsViewer.getTable().setSortDirection(dir);
                FindBreakingChangesPage.this._problemsViewer.getTable().setSortColumn(column);
                FindBreakingChangesPage.this._problemsViewer.refresh();
            }
        };
    }

    public TreeViewer getTreeViewer() {
        return this._treeViewer;
    }

    private void updateForm(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Problem problem = MigrationUtil.getProblemFromSelection(selection);
        if (problem != null) {
            if (CoreUtil.isNullOrEmpty((String)problem.html)) {
                this._browser.setText(this.generateFormText(problem));
            } else {
                this._browser.setText(problem.html);
            }
        } else {
            this._browser.setUrl("about:blank");
        }
    }

    @Override
    public void createSpecialDescriptor(Composite parent, int style) {
        String descriptor = "This step will help you to find breaking changes for Java, JSP, XML, and properties files. It will not support to find the front-end codes( e.g., javascript, css).\n For service builder, you just need to modify the changes on xxxServiceImp.java, xxxFinder.java, xxxModel.java. Others will be resovled in the Build Service step.";
        String url = "";
        Link link = SWTUtil.createHyperLink((Composite)this, (int)style, (String)"This step will help you to find breaking changes for Java, JSP, XML, and properties files. It will not support to find the front-end codes( e.g., javascript, css).\n For service builder, you just need to modify the changes on xxxServiceImp.java, xxxFinder.java, xxxModel.java. Others will be resovled in the Build Service step.", (int)1, (String)url);
        link.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
    }

    @Override
    public String getPageTitle() {
        return "Find Breaking Changes";
    }

    @Override
    public boolean getGridLayoutEqualWidth() {
        return false;
    }

    public TableViewer get_problemsViewer() {
        return this._problemsViewer;
    }
}

