/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.project.ui.upgrade.animated.PageAction;
import com.liferay.ide.project.ui.upgrade.animated.PageFinishAction;
import com.liferay.ide.project.ui.upgrade.animated.PageSkipAction;
import com.liferay.ide.project.ui.upgrade.animated.PageValidateEvent;
import com.liferay.ide.project.ui.upgrade.animated.SelectionChangedListener;
import com.liferay.ide.project.ui.upgrade.animated.UpgradeView;
import com.liferay.ide.ui.util.SWTUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class Page
extends Composite
implements SelectionChangedListener {
    public static final int DEFAULT_PAGE_WIDTH = 500;
    public static String WELCOME_PAGE_ID = "welcome";
    public static String INIT_CONFIGURE_PROJECT_PAGE_ID = "initconfigureproject";
    public static String UPGRADE_POM_PAGE_ID = "upgradepom";
    public static String DESCRIPTORS_PAGE_ID = "descriptors";
    public static String FINDBREACKINGCHANGES_PAGE_ID = "findbreackingchanges";
    public static String BUILDSERVICE_PAGE_ID = "buildservice";
    public static String LAYOUTTEMPLATE_PAGE_ID = "layouttemplate";
    public static String CUSTOMJSP_PAGE_ID = "customjsp";
    public static String EXTANDTHEME_PAGE_ID = "extandtheme";
    public static String COMPILE_PAGE_ID = "compile";
    public static String BUILD_PAGE_ID = "build";
    public static String SUMMARY_PAGE_ID = "summary";
    protected boolean canBack = true;
    protected boolean canNext = true;
    protected LiferayUpgradeDataModel dataModel;
    protected final List<UpgradeView.PageNavigatorListener> naviListeners = Collections.synchronizedList(new ArrayList());
    private String pageId;
    private int index;
    private String title = "title";
    protected PageAction[] actions;
    private PageAction selectedAction;
    private PageAction pageFinishAction = new PageFinishAction();
    private PageAction pageSkipAction = new PageSkipAction();
    protected final List<UpgradeView.PageValidationListener> pageValidationListeners = Collections.synchronizedList(new ArrayList());

    public static Control createHorizontalSpacer(Composite comp, int hSpan) {
        Label l = new Label(comp, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hSpan;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Control createSeparator(Composite parent, int hspan) {
        Label label = new Label(parent, 258);
        GridData gd = new GridData(4, 0x1000000, true, false, hspan, 1);
        label.setLayoutData((Object)gd);
        return label;
    }

    public Page(Composite parent, int style, LiferayUpgradeDataModel dataModel, String pageId, boolean hasFinishAndSkipAction) {
        super(parent, style);
        this.dataModel = dataModel;
        this.setLayout((Layout)new GridLayout(this.getGridLayoutCount(), this.getGridLayoutEqualWidth()));
        Label title = SWTUtil.createLabel((Composite)this, (String)this.getPageTitle(), (int)this.getGridLayoutCount());
        title.setFont(new Font(null, "Times New Roman", 14, 0));
        this.createSpecialDescriptor(this, style);
        this.setPageId(pageId);
        if (hasFinishAndSkipAction) {
            this.setActions(new PageAction[]{this.pageFinishAction, this.pageSkipAction});
        }
    }

    public void addPageNavigateListener(UpgradeView.PageNavigatorListener listener) {
        this.naviListeners.add(listener);
    }

    public void addPageValidationListener(UpgradeView.PageValidationListener listener) {
        this.pageValidationListeners.add(listener);
    }

    protected Label createLabel(Composite composite, String text) {
        Label label = new Label(composite, 0);
        label.setText(text);
        GridDataFactory.generate((Control)label, (int)2, (int)1);
        return label;
    }

    public void createSpecialDescriptor(Composite parent, int style) {
    }

    protected Text createTextField(Composite composite, int style) {
        Text text = new Text(composite, 0x800 | style);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    protected boolean doNextOperation() {
        return true;
    }

    public boolean equals(Object obj) {
        Page comp = (Page)obj;
        return this.pageId == comp.pageId;
    }

    public PageAction[] getActions() {
        return this.actions;
    }

    public int getGridLayoutCount() {
        return 1;
    }

    public boolean getGridLayoutEqualWidth() {
        return true;
    }

    public final int getIndex() {
        return this.index;
    }

    public String getPageId() {
        return this.pageId;
    }

    public abstract String getPageTitle();

    public PageAction getSelectedAction() {
        return this.selectedAction;
    }

    public PageAction getSelectedAction(String actionName) {
        if (actionName.equals("PageFinishAction")) {
            return this.pageFinishAction;
        }
        if (actionName.equals("PageSkipAction")) {
            return this.pageSkipAction;
        }
        return this.selectedAction;
    }

    protected final Image loadImage(String name) {
        URL url = null;
        try {
            url = ProjectUI.getDefault().getBundle().getEntry("images/" + name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageDescriptor imagedesc = ImageDescriptor.createFromURL(url);
        Image image = imagedesc.createImage();
        return image;
    }

    public String getTitle() {
        return this.title;
    }

    public final void setActions(PageAction[] actions) {
        this.actions = actions;
    }

    protected void setBackPage(boolean canBack) {
        this.canBack = canBack;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    protected void setNextPage(boolean canBack) {
        this.canNext = canBack;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public void setSelectedAction(PageAction selectedAction) {
        this.selectedAction = selectedAction;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected boolean showBackPage() {
        return this.canBack;
    }

    protected boolean showNextPage() {
        return this.canNext;
    }

    protected void triggerValidationEvent(PageValidateEvent pageValidationEvent) {
        pageValidationEvent.setPageId(this.getPageId());
        for (UpgradeView.PageValidationListener listener : this.pageValidationListeners) {
            listener.onValidation(pageValidationEvent);
        }
    }

    @Override
    public void onSelectionChanged(int targetSelection) {
    }
}

