/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.project.ui.upgrade.animated.PageAction;
import com.liferay.ide.project.ui.upgrade.animated.PageNavigateEvent;
import com.liferay.ide.project.ui.upgrade.animated.SelectionChangedListener;
import com.liferay.ide.project.ui.upgrade.animated.UpgradeView;
import com.liferay.ide.ui.util.SWTUtil;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;

public class SummaryPage
extends Page
implements SelectionChangedListener {
    private TableViewer tableViewer;
    private Image imageQuestion;

    public SummaryPage(Composite parent, int style, LiferayUpgradeDataModel dataModel) {
        super(parent, style, dataModel, SUMMARY_PAGE_ID, false);
        Composite container = new Composite((Composite)this, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = new TableViewer(container);
        this.tableViewer.setContentProvider((IContentProvider)new TableViewContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableViewLabelProvider());
        this.tableViewer.getControl().setBackground(this.getDisplay().getSystemColor(22));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() instanceof TableViewElement) {
                    TableViewElement tableViewElement = (TableViewElement)selection.getFirstElement();
                    int pageIndex = tableViewElement.pageIndex;
                    PageNavigateEvent navEvent = new PageNavigateEvent();
                    navEvent.setTargetPage(pageIndex);
                    for (UpgradeView.PageNavigatorListener listener : SummaryPage.this.naviListeners) {
                        listener.onPageNavigate(navEvent);
                    }
                }
            }
        });
        Table table = this.tableViewer.getTable();
        GridData tableData = new GridData(4, 4, true, false, 1, 1);
        tableData.heightHint = 175;
        table.setLayoutData((Object)tableData);
        table.setLinesVisible(false);
        this.createImages();
    }

    private void createImages() {
        this.imageQuestion = ImageDescriptor.createFromURL((URL)ProjectUI.getDefault().getBundle().getEntry("/images/question.png")).createImage();
    }

    @Override
    public void createSpecialDescriptor(Composite parent, int style) {
        String descriptor = "Upgrade results are summarized in the following table.\nIf there are still some failed or incomplete steps, you can go back to finish them.\nIf all the steps are well-done, congratulations! You have finished the whole upgrade process.\nNow you can try to deploy your projects to the Liferay Portal instance. For more upgrade information, please see <a>From Liferay 6 to Liferay 7</a>.";
        String url = "https://dev.liferay.com/develop/tutorials/-/knowledge_base/7-0/from-liferay-6-to-liferay-7";
        Link link = SWTUtil.createHyperLink((Composite)this, (int)style, (String)"Upgrade results are summarized in the following table.\nIf there are still some failed or incomplete steps, you can go back to finish them.\nIf all the steps are well-done, congratulations! You have finished the whole upgrade process.\nNow you can try to deploy your projects to the Liferay Portal instance. For more upgrade information, please see <a>From Liferay 6 to Liferay 7</a>.", (int)1, (String)url);
        link.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
    }

    @Override
    public String getPageTitle() {
        return "Summary";
    }

    @Override
    public int getGridLayoutCount() {
        return 2;
    }

    @Override
    public boolean getGridLayoutEqualWidth() {
        return false;
    }

    @Override
    public void onSelectionChanged(int targetSelection) {
        this.setInput();
    }

    private void setInput() {
        ArrayList<TableViewElement> TableViewElementList = new ArrayList<TableViewElement>();
        int pageNum = UpgradeView.getPageNumber();
        int i = 1;
        while (i < pageNum - 1) {
            Page page = UpgradeView.getPage(i);
            String pageTitle = page.getPageTitle();
            int pageIndex = i;
            PageAction pageAction = page.getSelectedAction();
            if (!pageTitle.equals("Ext and Theme Project")) {
                Image statusImage = pageAction == null ? this.imageQuestion : page.getSelectedAction().getBageImage();
                TableViewElement tableViewElement = new TableViewElement(pageTitle, statusImage, pageIndex);
                TableViewElementList.add(tableViewElement);
            }
            ++i;
        }
        TableViewElement[] tableViewElements = TableViewElementList.toArray(new TableViewElement[TableViewElementList.size()]);
        this.tableViewer.setInput((Object)tableViewElements);
    }

    private class TableViewContentProvider
    implements IStructuredContentProvider {
        private TableViewContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TableViewElement[]) {
                return (TableViewElement[])inputElement;
            }
            return new Object[]{inputElement};
        }
    }

    private class TableViewElement {
        private int pageIndex;
        private String pageTitle;
        private Image image;

        public TableViewElement(String pageTitle, Image image, int pageIndex) {
            this.pageTitle = pageTitle;
            this.image = image;
            this.pageIndex = pageIndex;
        }
    }

    class TableViewLabelProvider
    extends LabelProvider {
        TableViewLabelProvider() {
        }

        public Image getImage(Object element) {
            TableViewElement tableViewElement = (TableViewElement)element;
            return tableViewElement.image;
        }

        public String getText(Object element) {
            TableViewElement tableViewElement = (TableViewElement)element;
            return tableViewElement.pageTitle;
        }
    }
}

