/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.upgrade.ILiferayLegacyProjectUpdater;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.upgrade.LiferayUpgradeCompare;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.project.ui.upgrade.animated.PageValidateEvent;
import com.liferay.ide.project.ui.upgrade.animated.UpgradeView;
import com.liferay.ide.ui.util.SWTUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class UpgradePomPage
extends Page {
    private CheckboxTableViewer fTableViewer;
    private Button upgradeButton;
    private ILiferayLegacyProjectUpdater updater;
    private UpgradePomElement[] upgradePomElementsArray = null;

    public UpgradePomPage(Composite parent, int style, LiferayUpgradeDataModel dataModel) {
        super(parent, style, dataModel, UPGRADE_POM_PAGE_ID, true);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData descData = new GridData(1808);
        descData.grabExcessVerticalSpace = true;
        descData.grabExcessHorizontalSpace = true;
        this.setLayoutData(descData);
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)2048);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ProjectLabelProvider()));
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                UpgradePomPage.this.handleCompare((IStructuredSelection)event.getSelection());
            }
        });
        Table table = this.fTableViewer.getTable();
        GridData tableData = new GridData(1808);
        tableData.grabExcessVerticalSpace = true;
        tableData.grabExcessHorizontalSpace = true;
        tableData.horizontalAlignment = 4;
        table.setLayoutData((Object)tableData);
        Composite buttonContainer = new Composite((Composite)this, 0);
        buttonContainer.setLayout((Layout)new GridLayout(1, false));
        buttonContainer.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        Button selectAllButton = new Button(buttonContainer, 0);
        selectAllButton.setText("Select All");
        selectAllButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                Object object = UpgradePomPage.this.fTableViewer.getElementAt(i++);
                while (object != null) {
                    UpgradePomElement element = (UpgradePomElement)object;
                    if (!element.finished) {
                        UpgradePomPage.this.fTableViewer.setChecked((Object)element, true);
                    }
                    object = UpgradePomPage.this.fTableViewer.getElementAt(i++);
                }
            }
        });
        Button disSelectAllButton = new Button(buttonContainer, 0);
        disSelectAllButton.setText("Deselect All");
        disSelectAllButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        disSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpgradePomPage.this.fTableViewer.setAllChecked(false);
            }
        });
        this.upgradeButton = new Button(buttonContainer, 0);
        this.upgradeButton.setText("Upgrade Selected");
        this.upgradeButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.upgradeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UpgradePomPage.this.handleUpgradeEvent();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                UpgradePomElement element = (UpgradePomElement)event.getElement();
                if (element.finished && event.getChecked()) {
                    UpgradePomPage.this.fTableViewer.setChecked((Object)element, false);
                }
            }
        });
    }

    @Override
    public void createSpecialDescriptor(Composite parent, int style) {
        String descriptor = "This step will guide you to upgrade maven pom.xml files for the following aspects.\n  1. Convert and add dependencies for 7.x.\n  2. Remove the legacy 6.2 plugins.\n  3. Add 7.x maven plugins accroding to project type:\n  com.liferay.css.builder -> portlet, com.liferay.portal.tools.theme.builder -> theme, com.liferay.portal.tools.service.builder -> service-builder\nDouble clicking a file will bring up the compare editor of the original file and the upgraded file.";
        String url = "";
        Link link = SWTUtil.createHyperLink((Composite)this, (int)style, (String)"This step will guide you to upgrade maven pom.xml files for the following aspects.\n  1. Convert and add dependencies for 7.x.\n  2. Remove the legacy 6.2 plugins.\n  3. Add 7.x maven plugins accroding to project type:\n  com.liferay.css.builder -> portlet, com.liferay.portal.tools.theme.builder -> theme, com.liferay.portal.tools.service.builder -> service-builder\nDouble clicking a file will bring up the compare editor of the original file and the upgraded file.", (int)1, (String)url);
        link.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
    }

    @Override
    public String getPageTitle() {
        return "Upgrade POM Files";
    }

    private List<UpgradePomElement> getSelectedElements() {
        Object[] selectedElements = this.fTableViewer.getCheckedElements();
        ArrayList<UpgradePomElement> upgradePomElements = new ArrayList<UpgradePomElement>();
        if (selectedElements != null) {
            Object[] objectArray = selectedElements;
            int n = selectedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof UpgradePomElement) {
                    UpgradePomElement ele = (UpgradePomElement)element;
                    upgradePomElements.add(ele);
                }
                ++n2;
            }
        }
        return upgradePomElements;
    }

    private ILiferayLegacyProjectUpdater getUpdater() {
        if (this.updater == null) {
            this.updater = ProjectCore.getDefault().getLiferayLegacyProjectUpdater();
        }
        return this.updater;
    }

    private void handleCompare(IStructuredSelection selection) {
        UpgradePomElement element = (UpgradePomElement)selection.getFirstElement();
        IProject project = element.project;
        if (project.exists()) {
            IPath tmpDirPath = ProjectUI.getDefault().getStateLocation().append("tmp");
            File tmpDir = tmpDirPath.toFile();
            tmpDir.mkdirs();
            File tempPomFile = new File(tmpDir, "pom.xml");
            this.getUpdater().upgradePomFile(project, tempPomFile);
            IFile pomfile = project.getFile("pom.xml");
            LiferayUpgradeCompare lifeayDescriptorUpgradeCompre = new LiferayUpgradeCompare(pomfile.getLocation(), tmpDirPath.append("pom.xml"), "pom.xml");
            lifeayDescriptorUpgradeCompre.openCompareEditor();
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Confirm", (String)("project " + project.getName() + " doesn't exist"));
        }
    }

    private void handleFindEvent() {
        IProject[] projectArrys = CoreUtil.getAllProjects();
        final ArrayList<UpgradePomElement> upgradePomElements = new ArrayList<UpgradePomElement>();
        IProject[] iProjectArray = projectArrys;
        int n = projectArrys.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (ProjectUtil.isMavenProject((IProject)project) && this.getUpdater().isNeedUpgrade(project)) {
                upgradePomElements.add(new UpgradePomElement(project, false));
            }
            ++n2;
        }
        UIUtil.async((Runnable)new Runnable(){

            @Override
            public void run() {
                String message = "ok";
                UpgradePomPage.this.upgradePomElementsArray = upgradePomElements.toArray(new UpgradePomElement[0]);
                UpgradePomPage.this.fTableViewer.setInput((Object)UpgradePomPage.this.upgradePomElementsArray);
                if (UpgradePomPage.this.upgradePomElementsArray.length < 1) {
                    message = "No pom file needs to be upgraded";
                }
                PageValidateEvent pe = new PageValidateEvent();
                pe.setMessage(message);
                pe.setType(PageValidateEvent.WARNING);
                UpgradePomPage.this.triggerValidationEvent(pe);
            }
        });
    }

    private void handleUpgradeEvent() {
        try {
            List<UpgradePomElement> upgradePomElements = this.getSelectedElements();
            for (UpgradePomElement element : upgradePomElements) {
                this.getUpdater().upgradePomFile(element.project, null);
                element.finished = true;
            }
            this.fTableViewer.setInput((Object)this.upgradePomElementsArray);
            this.fTableViewer.setAllChecked(false);
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
    }

    @Override
    public void onSelectionChanged(int targetSelection) {
        Page selectedPage = UpgradeView.getPage(targetSelection);
        String selectedPageId = selectedPage.getPageId();
        if (!selectedPageId.equals(this.getPageId())) {
            return;
        }
        this.handleFindEvent();
    }

    private class ProjectLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    IColorProvider {
        private ProjectLabelProvider() {
        }

        public Image getImage(Object element) {
            return ProjectUI.getDefault().getImage("pom_file.gif");
        }

        public StyledString getStyledText(Object element) {
            UpgradePomElement upgadePomelement = (UpgradePomElement)element;
            String projectName = upgadePomelement.project.getName();
            String text = "pom.xml (" + projectName + ")";
            StyledString retVal = new StyledString();
            ColorRegistry colorReg = JFaceResources.getColorRegistry();
            String UPGRADE_POM_FRONT_COLOR = "UPGRADE_POM_FRONT_COLOR";
            Color frontColor = null;
            if (!colorReg.hasValueFor(UPGRADE_POM_FRONT_COLOR)) {
                frontColor = Display.getCurrent().getSystemColor(9);
                colorReg.put(UPGRADE_POM_FRONT_COLOR, frontColor.getRGB());
            } else {
                frontColor = colorReg.get(UPGRADE_POM_FRONT_COLOR);
            }
            if (upgadePomelement.finished) {
                text = String.valueOf(text) + "( Finished )";
                retVal.append(text, StyledString.createColorRegistryStyler((String)UPGRADE_POM_FRONT_COLOR, null));
            } else {
                retVal.append(text);
            }
            return retVal;
        }

        public Color getForeground(Object element) {
            if (element instanceof UpgradePomElement) {
                UpgradePomElement ele = (UpgradePomElement)element;
                if (ele.finished) {
                    return Display.getCurrent().getSystemColor(9);
                }
            }
            return Display.getCurrent().getSystemColor(2);
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    public class UpgradePomElement {
        public IProject project;
        public boolean finished;

        public UpgradePomElement(IProject project, boolean isFixed) {
            this.project = project;
            this.finished = isFixed;
        }
    }
}

