/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.model.ProjectNamedItem;
import com.liferay.ide.project.core.model.SDKProjectsImportOp;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.wizard.ProjectsCheckboxCustomPart;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;

public class ImportSDKProjectsCheckboxCustomPart
extends ProjectsCheckboxCustomPart {
    private FilteredListener<PropertyContentEvent> listener;
    protected Object[] selectedProjects = new ProjectRecord[0];
    protected long lastModified;
    protected IProject[] wsProjects;

    public void dispose() {
        if (this.listener != null) {
            this.op().property(SDKProjectsImportOp.PROP_SDK_LOCATION).detach(this.listener);
        }
        super.dispose();
    }

    @Override
    protected ElementList<ProjectNamedItem> getCheckboxList() {
        return this.op().getSelectedProjects();
    }

    @Override
    protected List<ProjectsCheckboxCustomPart.ProjectCheckboxElement> getInitItemsList() {
        ArrayList<ProjectsCheckboxCustomPart.ProjectCheckboxElement> checkboxElementList = new ArrayList<ProjectsCheckboxCustomPart.ProjectCheckboxElement>();
        Path sdkLocation = (Path)this.op().getSdkLocation().content();
        if (sdkLocation == null || !sdkLocation.toFile().exists()) {
            return checkboxElementList;
        }
        ProjectRecord[] projectRecords = this.updateProjectsList(PathBridge.create((Path)sdkLocation).toPortableString());
        if (projectRecords == null) {
            return checkboxElementList;
        }
        String context = null;
        ProjectRecord[] projectRecordArray = projectRecords;
        int n = projectRecords.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectRecord projectRecord = projectRecordArray[n2];
            String projectLocation = projectRecord.getProjectLocation().toPortableString();
            context = String.valueOf(projectRecord.getProjectName()) + " (" + projectLocation + ")";
            ProjectsCheckboxCustomPart.ProjectCheckboxElement checkboxElement = new ProjectsCheckboxCustomPart.ProjectCheckboxElement(projectRecord.getProjectName(), context, projectRecord.getProjectLocation().toPortableString());
            if (!projectRecord.hasConflicts()) {
                checkboxElementList.add(checkboxElement);
            }
            ++n2;
        }
        return checkboxElementList;
    }

    @Override
    protected DelegatingStyledCellLabelProvider.IStyledLabelProvider getLableProvider() {
        return new ProjectsCheckboxCustomPart.SDKImportProjectsLabelProvider();
    }

    private Object[] getProjectRecords() {
        ArrayList<Object> projectRecords = new ArrayList<Object>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            ProjectRecord projectRecord = (ProjectRecord)this.selectedProjects[i];
            if (this.isProjectInWorkspace(projectRecord.getProjectName())) {
                projectRecord.setHasConflicts(true);
            }
            projectRecords.add(this.selectedProjects[i]);
            ++i;
        }
        return projectRecords.toArray(new ProjectRecord[projectRecords.size()]);
    }

    private IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = ProjectUtil.getAllPluginsSDKProjects();
        }
        return this.wsProjects;
    }

    @Override
    protected ElementList<ProjectNamedItem> getSelectedElements() {
        return this.op().getSelectedProjects();
    }

    protected void init() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                Path sdkLocation;
                if (event.property().definition().equals(SDKProjectsImportOp.PROP_SDK_LOCATION) && (sdkLocation = (Path)ImportSDKProjectsCheckboxCustomPart.this.op().getSdkLocation().content()) != null) {
                    IStatus status = ProjectImportUtil.validateSDKPath((String)sdkLocation.toPortableString());
                    if (status.isOK()) {
                        if (sdkLocation.toFile().exists()) {
                            ImportSDKProjectsCheckboxCustomPart.this.checkAndUpdateCheckboxElement();
                        }
                    } else {
                        ImportSDKProjectsCheckboxCustomPart.this.checkBoxViewer.remove((Object[])ImportSDKProjectsCheckboxCustomPart.this.checkboxElements);
                        ImportSDKProjectsCheckboxCustomPart.this.updateValidation();
                    }
                }
            }
        };
        this.op().property(SDKProjectsImportOp.PROP_SDK_LOCATION).attach(this.listener);
    }

    private boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = this.getProjectsInWorkspace();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private SDKProjectsImportOp op() {
        return (SDKProjectsImportOp)this.getLocalModelElement().nearest(SDKProjectsImportOp.class);
    }

    private ProjectRecord[] updateProjectsList(String path) {
        block6: {
            ArrayList liferayProjectDirs;
            ArrayList eclipseProjectFiles;
            block7: {
                long modified;
                if (path == null || path.length() == 0) {
                    this.selectedProjects = new ProjectRecord[0];
                    return null;
                }
                File directory = new File(path);
                this.lastModified = modified = directory.lastModified();
                boolean dirSelected = true;
                this.selectedProjects = new ProjectRecord[0];
                eclipseProjectFiles = new ArrayList();
                liferayProjectDirs = new ArrayList();
                if (!directory.isDirectory()) break block6;
                if (ProjectUtil.collectSDKProjectsFromDirectory(eclipseProjectFiles, liferayProjectDirs, (File)directory, null, (boolean)true, (IProgressMonitor)new NullProgressMonitor())) break block7;
                return null;
            }
            try {
                this.selectedProjects = new ProjectRecord[eclipseProjectFiles.size() + liferayProjectDirs.size()];
                int index = 0;
                for (File eclipseProjectFile : eclipseProjectFiles) {
                    this.selectedProjects[index++] = new ProjectRecord(eclipseProjectFile);
                }
                for (File liferayProjectDir : liferayProjectDirs) {
                    this.selectedProjects[index++] = new ProjectRecord(liferayProjectDir);
                }
            }
            catch (Exception e) {
                ProjectUI.logError(e);
            }
        }
        Object[] projects = this.getProjectRecords();
        return (ProjectRecord[])projects;
    }

    @Override
    protected void updateValidation() {
        this.retval = Status.createOkStatus();
        Path sdkLocation = (Path)this.op().getSdkLocation().content();
        if (sdkLocation != null) {
            IStatus status = ProjectImportUtil.validateSDKPath((String)sdkLocation.toPortableString());
            if (status.isOK()) {
                int projectsCount = this.checkBoxViewer.getTable().getItemCount();
                int selectedProjectsCount = this.checkBoxViewer.getCheckedElements().length;
                if (projectsCount == 0) {
                    this.retval = Status.createErrorStatus((String)"No available projects can be imported.");
                }
                if (projectsCount > 0 && selectedProjectsCount == 0) {
                    this.retval = Status.createErrorStatus((String)"At least one project must be specified.");
                }
            }
        } else {
            this.retval = Status.createErrorStatus((String)"SDK path cannot be empty");
        }
        this.refreshValidation();
    }
}

