/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.model.SDKProjectsImportOp;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class ImportSDKProjectsWizard
extends SapphireWizard<SDKProjectsImportOp>
implements IWorkbenchWizard,
INewWizard {
    private static final String INITIAL_MESSAGE = "Please select at least one project to import.";
    private String title;
    private boolean supressedFirstErrorMessage = false;

    public ImportSDKProjectsWizard(IPath sdkPath) {
        super((Element)ImportSDKProjectsWizard.createDefaultOp(sdkPath), DefinitionLoader.sdef(ImportSDKProjectsWizard.class).wizard());
    }

    public ImportSDKProjectsWizard() {
        super((Element)ImportSDKProjectsWizard.createDefaultOp(), DefinitionLoader.sdef(ImportSDKProjectsWizard.class).wizard());
    }

    public ImportSDKProjectsWizard(String newTitle) {
        super((Element)ImportSDKProjectsWizard.createDefaultOp(), DefinitionLoader.sdef(ImportSDKProjectsWizard.class).wizard());
        this.title = newTitle;
    }

    private static SDKProjectsImportOp createDefaultOp() {
        return (SDKProjectsImportOp)SDKProjectsImportOp.TYPE.instantiate();
    }

    private static SDKProjectsImportOp createDefaultOp(IPath sdkPath) {
        SDKProjectsImportOp importOp = (SDKProjectsImportOp)SDKProjectsImportOp.TYPE.instantiate();
        importOp.setSdkLocation(PathBridge.create((IPath)sdkPath));
        return importOp;
    }

    public IWizardPage[] getPages() {
        IWizardPage[] wizardPages = super.getPages();
        if (wizardPages != null) {
            SapphireWizardPage wizardPage = (SapphireWizardPage)wizardPages[0];
            String message = wizardPage.getMessage();
            if (CoreUtil.isNullOrEmpty((String)message)) {
                wizardPage.setMessage(INITIAL_MESSAGE);
            }
            if (wizardPage.getMessageType() == 3 && !this.supressedFirstErrorMessage) {
                this.supressedFirstErrorMessage = true;
                wizardPage.setMessage(INITIAL_MESSAGE);
            }
        }
        if (this.title != null) {
            this.getContainer().getShell().setText(this.title);
        }
        return wizardPages;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

