/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.ui.quickfix;

import com.liferay.ide.gradle.core.GradleCore;
import com.liferay.ide.gradle.core.parser.GradleDependency;
import com.liferay.ide.gradle.core.parser.GradleDependencyUpdater;
import com.liferay.ide.gradle.ui.GradleUI;
import com.liferay.ide.project.core.modules.ServiceContainer;
import com.liferay.ide.project.core.util.TargetPlatformUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jdt.ui.text.java.correction.CUCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class QuickFixGradleDep
implements IQuickFixProcessor {
    private IFile gradleFile;

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        switch (problemId) {
            case 0x1000002: 
            case 268435846: {
                return true;
            }
        }
        return false;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) {
        if (locations == null || locations.length == 0) {
            return null;
        }
        IProject project = context.getCompilationUnit().getResource().getProject();
        this.gradleFile = project.getFile("build.gradle");
        ArrayList<IJavaCompletionProposal> resultingCollections = new ArrayList<IJavaCompletionProposal>();
        if (this.gradleFile.exists()) {
            int i = 0;
            while (i < locations.length) {
                IProblemLocation curr = locations[i];
                this.process(context, curr, resultingCollections);
                ++i;
            }
        }
        return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
    }

    private void process(IInvocationContext context, IProblemLocation problem, List<IJavaCompletionProposal> proposals) {
        int id = problem.getProblemId();
        if (id == 0) {
            return;
        }
        switch (id) {
            case 268435846: {
                this.importNotFoundProposal(context, problem, proposals);
                break;
            }
            case 0x1000002: {
                this.undefinedType(context, problem, proposals);
            }
        }
    }

    private void undefinedType(IInvocationContext context, IProblemLocation problem, Collection<IJavaCompletionProposal> proposals) {
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        String fullyQualifiedName = null;
        if (selectedNode instanceof Name) {
            Name node = (Name)selectedNode;
            fullyQualifiedName = node.getFullyQualifiedName();
        }
        boolean depWrapperCanFixed = false;
        try {
            ServiceContainer bundle;
            List serviceWrapperList = TargetPlatformUtil.getServiceWrapperList().getServiceList();
            List servicesList = TargetPlatformUtil.getServicesList().getServiceList();
            for (String wrapper : serviceWrapperList) {
                if (!wrapper.endsWith(fullyQualifiedName)) continue;
                bundle = TargetPlatformUtil.getServiceWrapperBundle((String)wrapper);
                this.createDepProposal(context, proposals, bundle);
            }
            if (!depWrapperCanFixed) {
                for (String service : servicesList) {
                    if (!service.endsWith(fullyQualifiedName)) continue;
                    bundle = TargetPlatformUtil.getServiceBundle((String)service);
                    this.createDepProposal(context, proposals, bundle);
                }
            }
        }
        catch (Exception e) {
            GradleCore.logError((String)"Gradle dependence got error", (Exception)e);
        }
    }

    private void importNotFoundProposal(IInvocationContext context, IProblemLocation problem, Collection<IJavaCompletionProposal> proposals) {
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        ImportDeclaration importDeclaration = (ImportDeclaration)ASTNodes.getParent((ASTNode)selectedNode, (int)26);
        if (importDeclaration == null) {
            return;
        }
        String importName = importDeclaration.getName().toString();
        boolean depWrapperCanFixed = false;
        try {
            ServiceContainer bundle;
            List serviceWrapperList = TargetPlatformUtil.getServiceWrapperList().getServiceList();
            List servicesList = TargetPlatformUtil.getServicesList().getServiceList();
            if (serviceWrapperList.contains(importName)) {
                bundle = TargetPlatformUtil.getServiceWrapperBundle((String)importName);
                depWrapperCanFixed = true;
                this.createDepProposal(context, proposals, bundle);
            }
            if (!depWrapperCanFixed && servicesList.contains(importName)) {
                bundle = TargetPlatformUtil.getServiceBundle((String)importName);
                this.createDepProposal(context, proposals, bundle);
            }
            if (TargetPlatformUtil.getThirdPartyBundleList((String)importName) != null) {
                bundle = TargetPlatformUtil.getThirdPartyBundleList((String)importName);
                this.createDepProposal(context, proposals, bundle);
            }
        }
        catch (Exception e) {
            GradleCore.logError((String)"Gradle dependence got error", (Exception)e);
        }
    }

    private void createDepProposal(final IInvocationContext context, Collection<IJavaCompletionProposal> proposals, ServiceContainer bundle) {
        final String bundleGroup = bundle.getBundleGroup();
        final String bundleName = bundle.getBundleName();
        final String bundleVersion = bundle.getBundleVersion();
        proposals.add((IJavaCompletionProposal)new CUCorrectionProposal("Add Gradle Dependence " + bundleName, context.getCompilationUnit(), null, 0){

            public void apply(IDocument document) {
                try {
                    GradleDependencyUpdater updater = new GradleDependencyUpdater(QuickFixGradleDep.this.gradleFile.getLocation().toFile());
                    List existDependencies = updater.getAllDependencies();
                    GradleDependency gd = new GradleDependency(bundleGroup, bundleName, bundleVersion);
                    if (!existDependencies.contains(gd)) {
                        updater.insertDependency(gd);
                        Files.write(QuickFixGradleDep.this.gradleFile.getLocation().toFile().toPath(), (Iterable<? extends CharSequence>)updater.getGradleFileContents(), StandardCharsets.UTF_8, new OpenOption[0]);
                        IProject project = context.getCompilationUnit().getResource().getProject();
                        HashSet<IProject> set = new HashSet<IProject>();
                        set.add(project);
                        CorePlugin.gradleWorkspaceManager().getCompositeBuild(set).synchronize(NewProjectHandler.IMPORT_AND_MERGE);
                    }
                }
                catch (Exception e) {
                    GradleCore.logError((String)"Gradle dependence got error", (Exception)e);
                }
            }

            public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
                return "Add dependenece";
            }

            public Image getImage() {
                Display display = UIUtil.getActiveShell().getDisplay();
                String file = null;
                try {
                    file = FileLocator.toFileURL((URL)GradleUI.getDefault().getBundle().getEntry("icons/e16/liferay_logo_16.png")).getFile();
                }
                catch (IOException e) {
                    GradleUI.logError(e);
                }
                return new Image((Device)display, file);
            }
        });
    }
}

