/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.sdk.core;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.sdk.core.ISDKListener;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.XMLMemento;
import org.osgi.framework.BundleContext;

public class SDKCorePlugin
extends Plugin {
    private static SDKCorePlugin plugin;
    public static final String PLUGIN_ID = "com.liferay.ide.sdk.core";
    public static final String PREF_KEY_OVERWRITE_USER_BUILD_FILE = "OVERWRITE_USER_BUILD_FILE";
    public static final String PREF_KEY_SDK_NAME = "sdk-name";
    public static final String PREFERENCE_ID = "com.liferay.ide.eclipse.sdk";
    private ISDKListener sdkListener;

    public static IStatus createErrorStatus(String msg) {
        return LiferayCore.createErrorStatus((String)PLUGIN_ID, (String)msg);
    }

    public static IStatus createErrorStatus(String pluginId, String msg, Throwable e) {
        return new Status(4, pluginId, msg, e);
    }

    public static IStatus createErrorStatus(Throwable t) {
        return LiferayCore.createErrorStatus((String)PLUGIN_ID, (Throwable)t);
    }

    public static SDKCorePlugin getDefault() {
        return plugin;
    }

    public static void logError(Exception e) {
        SDKCorePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
    }

    public static void logError(String msg, Throwable t) {
        SDKCorePlugin.getDefault().getLog().log(SDKCorePlugin.createErrorStatus(PLUGIN_ID, msg, t));
    }

    private void addSDKToMemento(SDK sdk, IMemento memento) {
        memento.putString("name", sdk.getName());
        memento.putString("location", sdk.getLocation().toPortableString());
        memento.putBoolean("default", sdk.isDefault());
    }

    private void copyMemento(IMemento from, IMemento to) {
        for (String name : from.getNames()) {
            to.putString(name, from.getString(name));
        }
    }

    private synchronized void saveGlobalSDKSettings(SDK[] sdks) {
        try {
            int n;
            LiferayCore.GLOBAL_SETTINGS_PATH.toFile().mkdirs();
            File sdkGlobalFile = LiferayCore.GLOBAL_SETTINGS_PATH.append("sdks.xml").toFile();
            HashSet<Object> existing = new HashSet<Object>();
            if (sdkGlobalFile.exists()) {
                try {
                    Object[] objectArray;
                    IMemento existingMemento = XMLMemento.loadMemento((InputStream)new FileInputStream(sdkGlobalFile));
                    if (existingMemento != null && !CoreUtil.isNullOrEmpty((Object[])(objectArray = existingMemento.getChildren("sdk")))) {
                        Object[] objectArray2 = objectArray;
                        int n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            Object child = objectArray2[n];
                            IPath loc = Path.fromPortableString((String)child.getString("location"));
                            if (loc != null && loc.toFile().exists()) {
                                boolean duplicate = false;
                                SDK[] sDKArray = sdks;
                                int n3 = sdks.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    SDK sdk = sDKArray[n4];
                                    if (sdk.getLocation().toFile().equals(loc.toFile())) {
                                        duplicate = true;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (!duplicate) {
                                    existing.add(child);
                                }
                            }
                            ++n;
                        }
                    }
                }
                catch (Exception existingMemento) {
                    // empty catch block
                }
            }
            XMLMemento sdkMementos = XMLMemento.createWriteRoot((String)"sdks");
            for (IMemento iMemento : existing) {
                this.copyMemento(iMemento, sdkMementos.createChild("sdk"));
            }
            SDK[] sDKArray = sdks;
            n = sdks.length;
            int n5 = 0;
            while (n5 < n) {
                SDK sDK = sDKArray[n5];
                IMemento memento = sdkMementos.createChild("sdk");
                this.addSDKToMemento(sDK, memento);
                ++n5;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(sdkGlobalFile);
            sdkMementos.save((OutputStream)fileOutputStream);
        }
        catch (Exception e) {
            SDKCorePlugin.logError("Unable to save global sdk settings", e);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.sdkListener = new ISDKListener(){

            @Override
            public void sdksAdded(SDK[] sdks) {
                SDKCorePlugin.this.saveGlobalSDKSettings(sdks);
            }

            @Override
            public void sdksChanged(SDK[] sdks) {
                SDKCorePlugin.this.saveGlobalSDKSettings(sdks);
            }

            @Override
            public void sdksRemoved(SDK[] sdks) {
                SDKCorePlugin.this.saveGlobalSDKSettings(sdks);
            }
        };
        SDKManager.getInstance().addSDKListener(this.sdkListener);
    }

    public void stop(BundleContext context) throws Exception {
        File createDir = SDKCorePlugin.getDefault().getStateLocation().append("create").toFile();
        if (createDir.exists()) {
            FileUtil.deleteDir((File)createDir, (boolean)true);
        }
        plugin = null;
        super.stop(context);
    }
}

