/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.jdt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaModelException;

public class SuperTypeHierarchyCache {
    private static final int CACHE_SIZE = 50;
    private static List<HierarchyCacheEntry> HIERACHY_CACHE = new ArrayList<HierarchyCacheEntry>(50);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTypeHierarchyToCache(ITypeHierarchy hierarchy) {
        List<HierarchyCacheEntry> list = HIERACHY_CACHE;
        synchronized (list) {
            int nEntries = HIERACHY_CACHE.size();
            if (nEntries >= 50) {
                HierarchyCacheEntry oldest = null;
                ArrayList<HierarchyCacheEntry> obsoleteHierarchies = new ArrayList<HierarchyCacheEntry>(50);
                int i = 0;
                while (i < nEntries) {
                    HierarchyCacheEntry entry = HIERACHY_CACHE.get(i);
                    ITypeHierarchy curr = entry.getTypeHierarchy();
                    if (!curr.exists() || hierarchy.contains(curr.getType())) {
                        obsoleteHierarchies.add(entry);
                    } else if (oldest == null || entry.getLastAccess() < oldest.getLastAccess()) {
                        oldest = entry;
                    }
                    ++i;
                }
                if (!obsoleteHierarchies.isEmpty()) {
                    i = 0;
                    while (i < obsoleteHierarchies.size()) {
                        SuperTypeHierarchyCache.removeHierarchyEntryFromCache((HierarchyCacheEntry)obsoleteHierarchies.get(i));
                        ++i;
                    }
                } else if (oldest != null) {
                    SuperTypeHierarchyCache.removeHierarchyEntryFromCache(oldest);
                }
            }
            HierarchyCacheEntry newEntry = new HierarchyCacheEntry(hierarchy);
            HIERACHY_CACHE.add(newEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ITypeHierarchy findTypeHierarchyInCache(IType type) {
        List<HierarchyCacheEntry> list = HIERACHY_CACHE;
        synchronized (list) {
            int i = HIERACHY_CACHE.size() - 1;
            while (i >= 0) {
                HierarchyCacheEntry curr = HIERACHY_CACHE.get(i);
                ITypeHierarchy hierarchy = curr.getTypeHierarchy();
                if (!hierarchy.exists()) {
                    SuperTypeHierarchyCache.removeHierarchyEntryFromCache(curr);
                } else if (hierarchy.contains(type)) {
                    curr.markAsAccessed();
                    return hierarchy;
                }
                --i;
            }
        }
        return null;
    }

    public static ITypeHierarchy getTypeHierarchy(IType type) throws JavaModelException {
        return SuperTypeHierarchyCache.getTypeHierarchy(type, null);
    }

    public static ITypeHierarchy getTypeHierarchy(IType type, IProgressMonitor progressMonitor) throws JavaModelException {
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.findTypeHierarchyInCache(type);
        if (hierarchy == null) {
            hierarchy = type.newTypeHierarchy(progressMonitor);
            SuperTypeHierarchyCache.addTypeHierarchyToCache(hierarchy);
        }
        return hierarchy;
    }

    public static boolean hasInCache(IType type) {
        return SuperTypeHierarchyCache.findTypeHierarchyInCache(type) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeHierarchyEntryFromCache(HierarchyCacheEntry entry) {
        List<HierarchyCacheEntry> list = HIERACHY_CACHE;
        synchronized (list) {
            entry.dispose();
            HIERACHY_CACHE.remove(entry);
        }
    }

    static /* synthetic */ void access$0(HierarchyCacheEntry hierarchyCacheEntry) {
        SuperTypeHierarchyCache.removeHierarchyEntryFromCache(hierarchyCacheEntry);
    }

    private static class HierarchyCacheEntry
    implements ITypeHierarchyChangedListener {
        private long lastAccess;
        private ITypeHierarchy typeHierarchy;

        public void dispose() {
            this.typeHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.typeHierarchy = null;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }

        public ITypeHierarchy getTypeHierarchy() {
            return this.typeHierarchy;
        }

        public void markAsAccessed() {
            this.lastAccess = System.currentTimeMillis();
        }

        public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
            SuperTypeHierarchyCache.removeHierarchyEntryFromCache(this);
        }

        public HierarchyCacheEntry(ITypeHierarchy hierarchy) {
            this.typeHierarchy = hierarchy;
            this.typeHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.markAsAccessed();
        }
    }
}

