/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.searchers.javamethod;

import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.IJavaMethodQuerySpecification;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.classnameprovider.IClassNameExtractor;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.classnameprovider.IClassNameExtractorProvider;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.classnameprovider.XPathClassNameExtractor;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.requestor.DefaultJavaMethodRequestor;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.requestor.IJavaMethodRequestor;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.requestor.IJavaMethodRequestorProvider;

public class JavaMethodQuerySpecification
implements IJavaMethodQuerySpecification {
    public static final IJavaMethodQuerySpecification DEFAULT = JavaMethodQuerySpecification.newDefaultJavaMethodQuerySpecification();
    private IJavaMethodRequestor requestor;
    private IJavaMethodRequestorProvider requestorProvider;
    private IClassNameExtractor classNameExtractor;
    private IClassNameExtractorProvider classNameExtractorProvider;

    public JavaMethodQuerySpecification(IJavaMethodRequestor requestor, IJavaMethodRequestorProvider requestorProvider, IClassNameExtractor classNameExtractor, IClassNameExtractorProvider classNameExtractorProvider) {
        this.requestor = requestor;
        this.requestorProvider = requestorProvider;
        this.classNameExtractor = classNameExtractor;
        this.classNameExtractorProvider = classNameExtractorProvider;
    }

    public static IJavaMethodQuerySpecification newDefaultJavaMethodQuerySpecification() {
        return new JavaMethodQuerySpecification(DefaultJavaMethodRequestor.INSTANCE, null, XPathClassNameExtractor.INSTANCE, null);
    }

    public static IJavaMethodQuerySpecification newJavaMethodQuerySpecification(Object querySpecification) {
        JavaMethodQuerySpecification specification = (JavaMethodQuerySpecification)JavaMethodQuerySpecification.newDefaultJavaMethodQuerySpecification();
        if (querySpecification instanceof IJavaMethodRequestor) {
            specification.setRequestor((IJavaMethodRequestor)querySpecification);
        }
        if (querySpecification instanceof IJavaMethodRequestorProvider) {
            specification.setRequestorProvider((IJavaMethodRequestorProvider)querySpecification);
        }
        if (querySpecification instanceof IClassNameExtractor) {
            specification.setClassNameExtractor((IClassNameExtractor)querySpecification);
        }
        if (querySpecification instanceof IClassNameExtractorProvider) {
            specification.setClassNameExtractorProvider((IClassNameExtractorProvider)querySpecification);
        }
        return specification;
    }

    private void setClassNameExtractorProvider(IClassNameExtractorProvider classNameExtractorProvider) {
        this.classNameExtractorProvider = classNameExtractorProvider;
    }

    private void setClassNameExtractor(IClassNameExtractor classNameExtractor) {
        this.classNameExtractor = classNameExtractor;
    }

    private void setRequestorProvider(IJavaMethodRequestorProvider requestorProvider) {
        this.requestorProvider = requestorProvider;
    }

    private void setRequestor(IJavaMethodRequestor requestor) {
        this.requestor = requestor;
    }

    @Override
    public IJavaMethodRequestor getRequestor(Object selectedNode, IFile file) {
        if (this.requestorProvider != null) {
            return this.requestorProvider.getRequestor(selectedNode, file);
        }
        return this.requestor;
    }

    @Override
    public IClassNameExtractor getClassNameExtractor(Object selectedNode, IFile file) {
        if (this.classNameExtractorProvider != null) {
            return this.classNameExtractorProvider.getClassNameExtractor(selectedNode, file);
        }
        return this.classNameExtractor;
    }
}

