/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.util;

import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.search.editor.internal.Messages;
import org.eclipse.wst.xml.search.editor.internal.Trace;

public class ExceptionHandler {
    private static ExceptionHandler fgInstance = new ExceptionHandler();

    public static void handle(CoreException e, Shell parent, String title, String message) {
        fgInstance.perform(e, parent, title, message);
    }

    protected void perform(CoreException e, Shell shell, String title, String message) {
        Trace.trace((byte)3, message, e);
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            this.displayMessageDialog(e.getMessage(), shell, title, message);
        }
    }

    private void displayMessageDialog(String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.length() == 0) {
            msg.write(Messages.ExceptionDialog_seeErrorLogMessage);
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }
}

