/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.java;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.java.IJavaElementMatcher;

public class JavaReferencesMatchersManager
extends AbstractRegistryManager {
    private static final JavaReferencesMatchersManager INSTANCE = new JavaReferencesMatchersManager();
    private static final String JAVA_REFERENCES_MATCHERS_EXTENSION_POINT = "javaReferencesMatchers";
    private Map<String, IJavaElementMatcher> matchersById = null;

    public static JavaReferencesMatchersManager getInstance() {
        return INSTANCE;
    }

    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.matchersById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addQuerySpecifications(this.matchersById, cf);
        }
    }

    public IJavaElementMatcher getMatcher(String querySpecificationId) {
        IJavaElementMatcher querySpecification;
        if (StringUtils.isEmpty((String)querySpecificationId)) {
            return IJavaElementMatcher.TRUE_MATCHER;
        }
        if (this.matchersById == null) {
            this.loadQuerySpecifications();
        }
        if ((querySpecification = this.matchersById.get(querySpecificationId)) == null) {
            querySpecification = IJavaElementMatcher.TRUE_MATCHER;
            this.matchersById.put(querySpecificationId, querySpecification);
        }
        return querySpecification;
    }

    private synchronized void loadQuerySpecifications() {
        if (this.matchersById != null) {
            return;
        }
        HashMap<String, IJavaElementMatcher> querySpecificationsById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.xml.search.editor", JAVA_REFERENCES_MATCHERS_EXTENSION_POINT);
            querySpecificationsById = new HashMap(cf.length);
            this.addQuerySpecifications(querySpecificationsById, cf);
        } else {
            querySpecificationsById = new HashMap<String, IJavaElementMatcher>();
        }
        this.matchersById = querySpecificationsById;
        super.addRegistryListenerIfNeeded();
    }

    private synchronized void addQuerySpecifications(Map<String, IJavaElementMatcher> querySpecificationsById, IConfigurationElement[] cf) {
        String id = null;
        IJavaElementMatcher querySpecification = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            id = ce.getAttribute("id");
            try {
                querySpecification = (IJavaElementMatcher)ce.createExecutableExtension("class");
                querySpecificationsById.put(id, querySpecification);
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load querySpecification for id: " + id, t);
            }
            ++n2;
        }
    }

    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.editor";
    }

    protected String getExtensionPoint() {
        return JAVA_REFERENCES_MATCHERS_EXTENSION_POINT;
    }
}

