/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers.expressions;

import java.util.ArrayList;
import java.util.List;

class ResultToken {
    private String realMatchingString;
    private final List<String> tokens = new ArrayList<String>();
    private String endToken;
    private int startOffsetOfStartToken = -1;

    public ResultToken(char token, String nodeValue, String matchingString) {
        this(token, nodeValue, matchingString, -1);
    }

    public ResultToken(char token, String nodeValue, int offset) {
        this(token, nodeValue, null, offset);
    }

    public ResultToken(char token, String nodeValue) {
        this(token, nodeValue, null, -1);
    }

    private ResultToken(char token, String nodeValue, String matchingString, int offset) {
        if (matchingString == null && offset == -1) {
            this.parse(token, nodeValue, this.tokens);
        } else if (matchingString != null) {
            this.parse(token, nodeValue, matchingString, this.tokens);
        } else if (offset != -1) {
            this.parse(token, nodeValue, offset, this.tokens);
        }
    }

    private void parse(char token, String nodeValue, String matchingString, List<String> tokens) {
        char c = 'X';
        boolean isLastCharIsSeparator = false;
        StringBuilder currentMatch = new StringBuilder();
        char[] chars = matchingString.toCharArray();
        int i = 0;
        while (i < chars.length) {
            c = chars[i];
            if (c == token) {
                if (i == 0 || isLastCharIsSeparator) {
                    currentMatch.append(c);
                } else {
                    isLastCharIsSeparator = true;
                    tokens.add(currentMatch.toString());
                    currentMatch.setLength(0);
                }
            } else {
                currentMatch.append(c);
                isLastCharIsSeparator = false;
            }
            ++i;
        }
        if (c == token) {
            tokens.add("");
        } else if (currentMatch.length() > 0) {
            tokens.add(currentMatch.toString());
        }
        char[] nodeValueChars = nodeValue.toCharArray();
        int startChar = chars.length;
        if (startChar < nodeValueChars.length) {
            StringBuilder endTokenBuilder = new StringBuilder();
            int i2 = startChar;
            while (i2 < nodeValueChars.length) {
                c = nodeValueChars[i2];
                if (c == token) break;
                endTokenBuilder.append(c);
                ++i2;
            }
            this.endToken = endTokenBuilder.toString();
        }
        this.realMatchingString = currentMatch.toString();
        if (this.endToken == null) {
            this.endToken = "";
        }
    }

    private void parse(char token, String nodeValue, int offset, List<String> tokens) {
        this.startOffsetOfStartToken = offset;
        char c = 'X';
        boolean isLastCharIsSeparator = false;
        StringBuilder currentMatch = new StringBuilder();
        char[] nodeValueChars = nodeValue.toCharArray();
        int i = 0;
        i = 0;
        while (i < offset) {
            c = nodeValueChars[i];
            if (c == token) {
                if (i == 0 || isLastCharIsSeparator) {
                    currentMatch.append(c);
                } else {
                    isLastCharIsSeparator = true;
                    tokens.add(currentMatch.toString());
                    currentMatch.setLength(0);
                }
            } else {
                currentMatch.append(c);
                isLastCharIsSeparator = false;
            }
            ++i;
        }
        if (c == token) {
            tokens.add("");
        } else if (currentMatch.length() > 0) {
            tokens.add(currentMatch.toString());
        }
        this.startOffsetOfStartToken = i - currentMatch.length();
        if (offset < nodeValueChars.length) {
            i = offset;
            while (i < nodeValueChars.length) {
                c = nodeValueChars[i];
                if (c == token) break;
                currentMatch.append(c);
                ++i;
            }
        }
        this.realMatchingString = currentMatch.toString();
    }

    private void parse(char token, String nodeValue, List<String> tokens) {
        boolean isLastCharIsSeparator = false;
        StringBuilder currentMatch = new StringBuilder();
        char[] nodeValueChars = nodeValue.toCharArray();
        int i = 0;
        while (i < nodeValueChars.length) {
            char c = nodeValueChars[i];
            if (c == token) {
                if (i == 0 || isLastCharIsSeparator) {
                    currentMatch.append(c);
                } else {
                    isLastCharIsSeparator = true;
                    tokens.add(currentMatch.toString());
                    currentMatch.setLength(0);
                }
            } else {
                currentMatch.append(c);
                isLastCharIsSeparator = false;
            }
            ++i;
        }
        if (currentMatch.length() > 0) {
            tokens.add(currentMatch.toString());
        }
    }

    public String getRealMatchingString() {
        return this.realMatchingString;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public String getEndToken() {
        return this.endToken;
    }

    public int getStartOffsetOfStartToken() {
        return this.startOffsetOfStartToken;
    }
}

