/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.ui.editor;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.hook.core.model.CustomJsp;
import com.liferay.ide.hook.core.model.CustomJspDir;
import com.liferay.ide.hook.core.model.Hook;
import com.liferay.ide.hook.core.model.Hook6xx;
import com.liferay.ide.hook.core.util.HookUtil;
import com.liferay.ide.hook.ui.HookUI;
import com.liferay.ide.ui.util.UIUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ui.swt.xml.editor.SapphireEditorForXml;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class HookXmlEditor
extends SapphireEditorForXml {
    protected boolean customModelDirty = false;
    private boolean ignoreCustomModelChanges;

    public HookXmlEditor() {
        super(Hook6xx.TYPE, null);
    }

    protected void adaptModel(Element model) {
        super.adaptModel(model);
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            public void handleTypedEvent(PropertyContentEvent event) {
                HookXmlEditor.this.handleCustomJspsPropertyChangedEvent(event);
            }
        };
        this.ignoreCustomModelChanges = true;
        model.attach((Listener)listener, String.valueOf(Hook.PROP_CUSTOM_JSPS.name()) + "/*");
        this.ignoreCustomModelChanges = false;
    }

    protected void createFormPages() throws PartInitException {
        this.addDeferredPage(1, "Overview", "HookConfigurationPage");
    }

    private void configureCustomJspValidation(final IProject project, String customerJspPath) {
        IFolder docFolder = CoreUtil.getDefaultDocrootFolder((IProject)project);
        if (docFolder != null) {
            IPath newPath = Path.fromOSString((String)customerJspPath);
            IPath pathValue = docFolder.getFullPath().append(newPath);
            final IFolder customJspFolder = project.getFolder(pathValue.makeRelativeTo(project.getFullPath()));
            boolean needAddCustomJspValidation = HookUtil.configureJSPSyntaxValidationExclude((IProject)project, (IFolder)customJspFolder, (boolean)false);
            if (!needAddCustomJspValidation) {
                UIUtil.async((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        boolean addDisableCustomJspValidation = MessageDialog.openQuestion((Shell)UIUtil.getActiveShell(), (String)Msgs.disableCustomValidationTitle, (String)Msgs.disableCustomValidationMsg);
                        if (addDisableCustomJspValidation) {
                            new WorkspaceJob(" disable custom jsp validation for " + project.getName()){

                                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                    HookUtil.configureJSPSyntaxValidationExclude((IProject)project, (IFolder)customJspFolder, (boolean)true);
                                    project.build(6, (IProgressMonitor)new NullProgressMonitor());
                                    return Status.OK_STATUS;
                                }
                            }.schedule();
                        }
                    }
                });
            }
        }
    }

    private void copyCustomJspsToProject(IPath portalDir, ElementList<CustomJsp> customJsps) {
        try {
            CustomJspDir customJspDirElement = (CustomJspDir)((Hook)this.getModelElement().nearest(Hook.class)).getCustomJspDir().content();
            if (customJspDirElement != null && customJspDirElement.validation().ok()) {
                org.eclipse.sapphire.modeling.Path customJspDir = (org.eclipse.sapphire.modeling.Path)customJspDirElement.getValue().content();
                IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)this.getProject());
                if (webproject != null) {
                    IFolder defaultDocroot = webproject.getDefaultDocrootFolder();
                    IFolder customJspFolder = defaultDocroot.getFolder(customJspDir.toPortableString());
                    for (CustomJsp customJsp : customJsps) {
                        IFile customJspFile;
                        String content = (String)customJsp.getValue().content();
                        if (CoreUtil.empty((String)content) || (customJspFile = customJspFolder.getFile(content)).exists()) continue;
                        IPath portalJsp = portalDir.append(content);
                        try {
                            CoreUtil.makeFolders((IFolder)((IFolder)customJspFile.getParent()));
                            if (portalJsp.toFile().exists()) {
                                customJspFile.create((InputStream)new FileInputStream(portalJsp.toFile()), true, null);
                                continue;
                            }
                            CoreUtil.createEmptyFile((IFile)customJspFile);
                        }
                        catch (Exception e) {
                            HookUI.logError(e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            HookUI.logError(e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.customModelDirty) {
            IPath portalDir;
            Hook hook = (Hook)this.getModelElement().nearest(Hook.class);
            ElementList customJsps = hook.getCustomJsps();
            ILiferayProject liferayProject = LiferayCore.create((Object)this.getProject());
            ILiferayPortal portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class);
            if (portal != null && (portalDir = portal.getAppServerPortalDir()) != null) {
                this.copyCustomJspsToProject(portalDir, (ElementList<CustomJsp>)customJsps);
            }
            this.customModelDirty = false;
            super.doSave(monitor);
            this.firePropertyChange(257);
            ElementHandle customJspDir = hook.getCustomJspDir();
            if (customJspDir != null && !customJspDir.empty()) {
                Value customJspPath = ((CustomJspDir)customJspDir.content()).getValue();
                String customeJspValue = ((org.eclipse.sapphire.modeling.Path)customJspPath.content()).makeRelative().toPortableString();
                this.configureCustomJspValidation(this.getProject(), customeJspValue);
            }
        } else {
            super.doSave(monitor);
        }
    }

    public InputStream getFileContents() throws CoreException, MalformedURLException, IOException {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            return ((FileEditorInput)editorInput).getFile().getContents();
        }
        if (editorInput instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)editorInput).getStorage().getContents();
        }
        if (editorInput instanceof FileStoreEditorInput) {
            return ((FileStoreEditorInput)editorInput).getURI().toURL().openStream();
        }
        return null;
    }

    protected void handleCustomJspsPropertyChangedEvent(PropertyContentEvent event) {
        if (this.ignoreCustomModelChanges) {
            return;
        }
        this.customModelDirty = true;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        if (this.customModelDirty) {
            return true;
        }
        return super.isDirty();
    }

    protected void pageChange(int pageIndex) {
        this.ignoreCustomModelChanges = true;
        super.pageChange(pageIndex);
        this.ignoreCustomModelChanges = false;
    }

    private static class Msgs
    extends NLS {
        public static String disableCustomValidationMsg;
        public static String disableCustomValidationTitle;

        static {
            Msgs.initializeMessages((String)HookXmlEditor.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

