/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.ui.wizard;

import com.liferay.ide.core.util.FileListing;
import com.liferay.ide.project.ui.wizard.StringArrayTableWizardSection;
import com.liferay.ide.ui.wizard.ExternalFileSelectionDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class CustomJSPsTableWizardSection
extends StringArrayTableWizardSection {
    protected Button addFromPortalButton;
    protected File portalDir;

    public CustomJSPsTableWizardSection(Composite parent, String componentLabel, String dialogTitle, String addButtonLabel, String editButtonLabel, String removeButtonLabel, String[] columnTitles, String[] fieldLabels, Image labelProviderImage, IDataModel model, String propertyName) {
        super(parent, componentLabel, dialogTitle, addButtonLabel, editButtonLabel, removeButtonLabel, columnTitles, fieldLabels, labelProviderImage, model, propertyName);
    }

    public void setPortalDir(File dir) {
        this.portalDir = dir;
    }

    protected void addButtonsToButtonComposite(Composite buttonCompo, String addButtonLabel, String editButtonLabel, String removeButtonLabel) {
        this.addFromPortalButton = new Button(buttonCompo, 8);
        this.addFromPortalButton.setText(Msgs.addFromLiferay);
        this.addFromPortalButton.setLayoutData((Object)new GridData(258));
        this.addFromPortalButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                CustomJSPsTableWizardSection.this.handleAddFromPortalButtonSelected();
            }
        });
        super.addButtonsToButtonComposite(buttonCompo, addButtonLabel, editButtonLabel, removeButtonLabel);
    }

    protected void handleAddFromPortalButtonSelected() {
        if (this.portalDir == null || !this.portalDir.exists()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Msgs.addJSP, (String)Msgs.couldNotFindPortalRoot);
            return;
        }
        Path rootPath = new Path(this.portalDir.getPath());
        ExternalFileSelectionDialog dialog = new ExternalFileSelectionDialog(this.getShell(), (ViewerFilter)new JSPFileViewerFilter(this.portalDir, new String[]{"html"}), true, false);
        dialog.setTitle(Msgs.liferayCustomJSP);
        dialog.setMessage(Msgs.selectJSPToCustomize);
        dialog.setInput((Object)this.portalDir);
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            int i = 0;
            while (i < selected.length) {
                IPath filePath = Path.fromOSString((String)((File)selected[i]).getPath());
                this.addStringArray(new String[]{"/" + filePath.makeRelativeTo((IPath)rootPath).toPortableString()});
                ++i;
            }
        }
    }

    protected static class JSPFileViewerFilter
    extends ViewerFilter {
        protected File base;
        protected List<File> cachedDirs = new ArrayList<File>();
        protected String[] roots = null;
        protected IPath[] validRoots;

        public JSPFileViewerFilter(File base, String[] roots) {
            this.base = base;
            this.roots = roots;
            this.validRoots = new IPath[roots.length];
            int i = 0;
            while (i < roots.length) {
                File fileRoot = new File(base, roots[i]);
                if (fileRoot.exists()) {
                    this.validRoots[i] = new Path(fileRoot.getPath());
                }
                ++i;
            }
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof File) {
                File file = (File)element;
                Path filePath = new Path(file.getPath());
                boolean validRootFound = false;
                IPath[] iPathArray = this.validRoots;
                int n = this.validRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath validRoot = iPathArray[n2];
                    if (validRoot.isPrefixOf((IPath)filePath)) {
                        validRootFound = true;
                        break;
                    }
                    ++n2;
                }
                if (!validRootFound) {
                    return false;
                }
                if (this.cachedDirs.contains(file)) {
                    return true;
                }
                if (file.isDirectory()) {
                    if (this.directoryContainsFiles(file, "jsp", viewer)) {
                        this.cachedDirs.add(file);
                        return true;
                    }
                } else if (filePath.getFileExtension().contains("jsp")) {
                    return true;
                }
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean directoryContainsFiles(File dir, String ext, Viewer viewer) {
            try {
                File file;
                Path filePath;
                List files = FileListing.getFileListing((File)dir);
                Iterator iterator = files.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return false;
                } while ((filePath = new Path((file = (File)iterator.next()).getPath())).getFileExtension() == null || !filePath.getFileExtension().contains(ext));
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return false;
        }
    }

    private static class Msgs
    extends NLS {
        public static String addFromLiferay;
        public static String addJSP;
        public static String couldNotFindPortalRoot;
        public static String liferayCustomJSP;
        public static String selectJSPToCustomize;

        static {
            Msgs.initializeMessages((String)CustomJSPsTableWizardSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

