/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.internal.properties;

import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.search.core.properties.DefaultPropertiesRequestor;
import org.eclipse.wst.xml.search.core.properties.IPropertiesQuerySpecification;
import org.eclipse.wst.xml.search.core.properties.IPropertiesRequestor;
import org.eclipse.wst.xml.search.core.properties.IPropertiesRequestorProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.container.FolderContainerProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.container.IMultiResourceProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.container.IResourceProvider;

public class PropertiesQuerySpecification
implements IPropertiesQuerySpecification {
    public static final IPropertiesQuerySpecification DEFAULT = PropertiesQuerySpecification.newDefaultQuerySpecification();
    private IResourceProvider containerProvider;
    private IMultiResourceProvider multiContainerProvider;
    private IPropertiesRequestor requestor;

    protected PropertiesQuerySpecification(IResourceProvider containerProvider, IMultiResourceProvider multiContainerProvider, IPropertiesRequestor requestor) {
        this.containerProvider = containerProvider;
        this.multiContainerProvider = multiContainerProvider;
        this.requestor = requestor;
    }

    @Override
    public IResource getResource(Object selectedNode, IResource resource) {
        return this.containerProvider.getResource(selectedNode, resource);
    }

    @Override
    public IPropertiesRequestor getRequestor() {
        return this.requestor;
    }

    public static IPropertiesQuerySpecification newDefaultQuerySpecification() {
        return new PropertiesQuerySpecification(FolderContainerProvider.INSTANCE, null, DefaultPropertiesRequestor.INSTANCE);
    }

    public static IPropertiesQuerySpecification newQuerySpecification(Object querySpecification) {
        PropertiesQuerySpecification specification = (PropertiesQuerySpecification)PropertiesQuerySpecification.newDefaultQuerySpecification();
        if (querySpecification instanceof IResourceProvider) {
            specification.setContainerProvider((IResourceProvider)querySpecification);
        }
        if (querySpecification instanceof IMultiResourceProvider) {
            specification.setMultiContainerProvider((IMultiResourceProvider)querySpecification);
        }
        if (querySpecification instanceof IPropertiesRequestorProvider) {
            specification.setRequestor(((IPropertiesRequestorProvider)querySpecification).getRequestor());
        }
        return specification;
    }

    private void setMultiContainerProvider(IMultiResourceProvider multiContainerProvider) {
        this.multiContainerProvider = multiContainerProvider;
    }

    private void setRequestor(IPropertiesRequestor requestor) {
        this.requestor = requestor;
    }

    private void setContainerProvider(IResourceProvider containerProvider) {
        this.containerProvider = containerProvider;
    }

    @Override
    public boolean isMultiResource() {
        return this.multiContainerProvider != null;
    }

    @Override
    public IResource[] getResources(Object selectedNode, IResource resource) {
        return this.multiContainerProvider.getResources(selectedNode, resource);
    }
}

