/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.internal.queryspecifications;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecification;
import org.eclipse.wst.xml.search.core.queryspecifications.IXPathProcessorIdProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.container.IMultiResourceProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.container.IMultiStorageProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.container.IResourceProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.container.IStorageProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.container.ProjectContainerProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.querybuilder.DefaultStringQueryBuilderProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.querybuilder.IStringQueryBuilder;
import org.eclipse.wst.xml.search.core.queryspecifications.querybuilder.IStringQueryBuilderProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.AllXMLExtensionFilesXMLSearchRequestor;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.IXMLSearchRequestor;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.IXMLSearchRequestorProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.visitor.IXMLSearchDOMDocumentVisitor;
import org.eclipse.wst.xml.search.core.queryspecifications.visitor.IXMLSearchVisitorProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.visitor.XPathNodeSetSearchVisitor;

public class XMLQuerySpecification
implements IXMLQuerySpecification {
    public static final IXMLQuerySpecification INSTANCE = XMLQuerySpecification.newDefaultQuerySpecification();
    private IStorageProvider storageProvider;
    private IMultiStorageProvider multiStorageProvider;
    private IResourceProvider containerProvider;
    private IMultiResourceProvider multiContainerProvider;
    private IXMLSearchRequestor requestor;
    private IXMLSearchDOMDocumentVisitor visitor;
    private IStringQueryBuilderProvider queryBuilderProvider;
    private String xpathProcessorId;

    protected XMLQuerySpecification(IResourceProvider containerProvider, IMultiResourceProvider multiContainerProvider, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, IStringQueryBuilderProvider queryBuilderProvider, String xpathProcessorId) {
        this.containerProvider = containerProvider;
        this.multiContainerProvider = multiContainerProvider;
        this.storageProvider = null;
        this.multiStorageProvider = null;
        this.requestor = requestor;
        this.visitor = visitor;
        this.queryBuilderProvider = queryBuilderProvider;
        this.xpathProcessorId = xpathProcessorId;
    }

    @Override
    public IResource getResource(Object selectedNode, IResource resource) {
        return this.containerProvider.getResource(selectedNode, resource);
    }

    @Override
    public IResource[] getResources(Object selectedNode, IResource resource) {
        if (this.multiContainerProvider == null) {
            return null;
        }
        return this.multiContainerProvider.getResources(selectedNode, resource);
    }

    @Override
    public boolean isMultiResource() {
        return this.multiContainerProvider != null;
    }

    @Override
    public IStorage getStorage(Object selectedNode, IResource resource) {
        if (this.storageProvider == null) {
            return null;
        }
        return this.storageProvider.getStorage(selectedNode, resource);
    }

    @Override
    public IStorage[] getStorages(Object selectedNode, IResource resource) {
        if (this.multiStorageProvider == null) {
            return null;
        }
        return this.multiStorageProvider.getStorages(selectedNode, resource);
    }

    @Override
    public boolean isSimpleStorage() {
        return this.storageProvider != null;
    }

    @Override
    public boolean isMultiStorage() {
        return this.multiStorageProvider != null;
    }

    @Override
    public IXMLSearchRequestor getRequestor() {
        return this.requestor;
    }

    @Override
    public IXMLSearchDOMDocumentVisitor getVisitor() {
        return this.visitor;
    }

    public static IXMLQuerySpecification newDefaultQuerySpecification() {
        return new XMLQuerySpecification(ProjectContainerProvider.INSTANCE, null, AllXMLExtensionFilesXMLSearchRequestor.INSTANCE, XPathNodeSetSearchVisitor.INSTANCE, DefaultStringQueryBuilderProvider.INSTANCE, null);
    }

    public static IXMLQuerySpecification newQuerySpecification(Object querySpecification) {
        XMLQuerySpecification specification = (XMLQuerySpecification)XMLQuerySpecification.newDefaultQuerySpecification();
        if (querySpecification instanceof IResourceProvider) {
            specification.setContainerProvider((IResourceProvider)querySpecification);
        }
        if (querySpecification instanceof IMultiResourceProvider) {
            specification.setMultiContainerProvider((IMultiResourceProvider)querySpecification);
        }
        if (querySpecification instanceof IStorageProvider) {
            specification.setStorageProvider((IStorageProvider)querySpecification);
        }
        if (querySpecification instanceof IMultiStorageProvider) {
            specification.setMultiStorageProvider((IMultiStorageProvider)querySpecification);
        }
        if (querySpecification instanceof IXMLSearchRequestorProvider) {
            specification.setRequestor(((IXMLSearchRequestorProvider)querySpecification).getRequestor());
        }
        if (querySpecification instanceof IXMLSearchVisitorProvider) {
            specification.setVisitor(((IXMLSearchVisitorProvider)querySpecification).getVisitor());
        }
        if (querySpecification instanceof IStringQueryBuilderProvider) {
            specification.setStringQueryBuilderProvider((IStringQueryBuilderProvider)querySpecification);
        }
        if (querySpecification instanceof IXPathProcessorIdProvider) {
            specification.setXPathEvaluatorId(((IXPathProcessorIdProvider)querySpecification).getXPathProcessorId());
        }
        return specification;
    }

    private void setMultiContainerProvider(IMultiResourceProvider multiContainerProvider) {
        this.multiContainerProvider = multiContainerProvider;
    }

    private void setStorageProvider(IStorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    private void setMultiStorageProvider(IMultiStorageProvider multiStorageProvider) {
        this.multiStorageProvider = multiStorageProvider;
    }

    private void setXPathEvaluatorId(String xPathEvaluatorId) {
        this.xpathProcessorId = xPathEvaluatorId;
    }

    private void setStringQueryBuilderProvider(IStringQueryBuilderProvider queryBuilderProvider) {
        this.queryBuilderProvider = queryBuilderProvider;
    }

    private void setRequestor(IXMLSearchRequestor requestor) {
        this.requestor = requestor;
    }

    private void setVisitor(IXMLSearchDOMDocumentVisitor visitor) {
        this.visitor = visitor;
    }

    private void setContainerProvider(IResourceProvider containerProvider) {
        this.containerProvider = containerProvider;
    }

    @Override
    public IStringQueryBuilder getEqualsStringQueryBuilder() {
        return this.queryBuilderProvider.getEqualsStringQueryBuilder();
    }

    @Override
    public IStringQueryBuilder getStartsWithStringQueryBuilder() {
        return this.queryBuilderProvider.getStartsWithStringQueryBuilder();
    }

    @Override
    public String getXPathProcessorId() {
        return this.xpathProcessorId;
    }
}

