/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.statics;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.internal.Trace;
import org.eclipse.wst.xml.search.core.statics.IStaticValueQuerySpecification;
import org.eclipse.wst.xml.search.core.statics.StaticValueQuerySpecification;
import org.eclipse.wst.xml.search.core.util.StringUtils;

public class StaticValueQuerySpecificationManager
extends AbstractRegistryManager {
    private static final StaticValueQuerySpecificationManager INSTANCE = new StaticValueQuerySpecificationManager();
    private static final String XML_QUERY_SPECIFICATIONS_EXTENSION_POINT = "staticValueQuerySpecifications";
    private Map<String, IStaticValueQuerySpecification> querySpecificationsById = null;

    public static StaticValueQuerySpecificationManager getDefault() {
        return INSTANCE;
    }

    @Override
    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.querySpecificationsById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addQuerySpecifications(this.querySpecificationsById, cf);
        }
    }

    public IStaticValueQuerySpecification getQuerySpecification(String querySpecificationId) {
        IStaticValueQuerySpecification querySpecification;
        if (StringUtils.isEmpty(querySpecificationId)) {
            return null;
        }
        if (this.querySpecificationsById == null) {
            this.loadQuerySpecifications();
        }
        if ((querySpecification = this.querySpecificationsById.get(querySpecificationId)) == null) {
            this.querySpecificationsById.put(querySpecificationId, querySpecification);
        }
        return querySpecification;
    }

    private synchronized void loadQuerySpecifications() {
        if (this.querySpecificationsById != null) {
            return;
        }
        HashMap<String, IStaticValueQuerySpecification> querySpecificationsById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.xml.search.core", XML_QUERY_SPECIFICATIONS_EXTENSION_POINT);
            querySpecificationsById = new HashMap(cf.length);
            this.addQuerySpecifications(querySpecificationsById, cf);
        } else {
            querySpecificationsById = new HashMap<String, IStaticValueQuerySpecification>();
        }
        this.querySpecificationsById = querySpecificationsById;
        super.addRegistryListenerIfNeeded();
    }

    private synchronized void addQuerySpecifications(Map<String, IStaticValueQuerySpecification> querySpecificationsById, IConfigurationElement[] cf) {
        String id = null;
        IStaticValueQuerySpecification querySpecification = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            id = ce.getAttribute("id");
            try {
                querySpecification = StaticValueQuerySpecification.newQuerySpecification(ce.createExecutableExtension("class"));
                if (querySpecification != null) {
                    querySpecificationsById.put(id, querySpecification);
                }
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load querySpecification for id: " + id, t);
            }
            ++n2;
        }
    }

    @Override
    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.core";
    }

    @Override
    protected String getExtensionPoint() {
        return XML_QUERY_SPECIFICATIONS_EXTENSION_POINT;
    }
}

